/*
 * Decompiled with CFR 0.152.
 */
package io.evanwong.oss.hipchat.v2.rooms;

import io.evanwong.oss.hipchat.v2.commons.Created;
import io.evanwong.oss.hipchat.v2.commons.PostRequest;
import io.evanwong.oss.hipchat.v2.rooms.Privacy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.http.client.HttpClient;

public class CreateRoomRequest
extends PostRequest<Created> {
    private String topic;
    private Boolean guestAcccess;
    private String name;
    private String ownerUserId;
    private Privacy privacy;

    CreateRoomRequest(String topic, Boolean guestAcccess, String name, String ownerUserId, Privacy privacy, String accessToken, HttpClient httpClient, ExecutorService executorService) {
        super(accessToken, httpClient, executorService);
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name is required.");
        }
        this.topic = topic;
        this.guestAcccess = guestAcccess;
        this.name = name;
        this.ownerUserId = ownerUserId;
        this.privacy = privacy;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setGuestAcccess(Boolean guestAcccess) {
        this.guestAcccess = guestAcccess;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOwnerUserId(String ownerUserId) {
        this.ownerUserId = ownerUserId;
    }

    public void setPrivacy(Privacy privacy) {
        this.privacy = privacy;
    }

    @Override
    protected String getPath() {
        return "/room";
    }

    @Override
    protected Map<String, Object> toQueryMap() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.topic != null) {
            params.put("topic", this.topic);
        }
        if (this.guestAcccess != null) {
            params.put("guest_acccess", this.guestAcccess);
        }
        params.put("name", this.name);
        if (this.ownerUserId != null) {
            params.put("owner_user_id", this.ownerUserId);
        }
        if (this.privacy != null) {
            params.put("privacy", this.privacy.getValue());
        }
        return params;
    }
}

