/*
 * Decompiled with CFR 0.152.
 */
package io.evanwong.oss.hipchat.v2.commons;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import io.evanwong.oss.hipchat.v2.commons.Request$$Lambda$1;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Request<T> {
    private static final Logger log = LoggerFactory.getLogger(Request.class);
    protected static final String BASE_URL = "https://api.hipchat.com/v2";
    protected ExecutorService executorService;
    protected String accessToken;
    protected HttpClient httpClient;
    private final ObjectMapper objectMapper = new ObjectMapper();
    protected final ObjectWriter objectWriter = this.objectMapper.writer();
    protected final ObjectReader objectReader;

    protected abstract Map<String, Object> toQueryMap();

    protected abstract HttpResponse request() throws IOException;

    protected abstract String getPath();

    protected String getEncodedPath() {
        String path = this.getPath();
        String[] tokens = path.split("/");
        String encodedPath = "";
        URLCodec urlCodec = new URLCodec();
        try {
            for (String token : tokens) {
                if (token.isEmpty()) continue;
                encodedPath = encodedPath + "/" + urlCodec.encode(token).replace("+", "%20");
            }
        }
        catch (EncoderException e) {
            log.error("Failed to encode the path properly.", (Throwable)e);
        }
        return encodedPath;
    }

    protected Request(String accessToken, HttpClient httpClient, ExecutorService executorService) {
        this.executorService = executorService;
        this.accessToken = accessToken;
        this.httpClient = httpClient;
        this.objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        this.objectReader = this.objectMapper.reader(this.getParameterClass());
    }

    public Future<T> execute() {
        Future future = this.executorService.submit(Request$$Lambda$1.lambdaFactory$(this));
        return future;
    }

    protected Class<T> getParameterClass() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    private /* synthetic */ Object lambda$execute$1() throws Exception {
        String content;
        HttpResponse response = this.request();
        int status = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        String string = content = entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
        if (status >= 200 && status < 300) {
            if (content == null) {
                return this.getParameterClass().newInstance();
            }
            return this.objectReader.readValue(content);
        }
        log.error("Invalid response status: {}, content: {}", (Object)status, (Object)content);
        return null;
    }

    static /* synthetic */ Object access$lambda$0(Request request) {
        return request.lambda$execute$1();
    }
}

