/*
 * Decompiled with CFR 0.152.
 */
package io.evanwong.oss.hipchat.v2.commons;

import io.evanwong.oss.hipchat.v2.commons.Request;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GetRequest<T>
extends Request<T> {
    private static final Logger log = LoggerFactory.getLogger(GetRequest.class);
    protected List<String> expansions = new ArrayList<String>();

    protected GetRequest(String accessToken, HttpClient httpClient, ExecutorService executorService) {
        super(accessToken, httpClient, executorService);
    }

    @Override
    protected HttpResponse request() throws IOException {
        String query;
        Map<String, Object> params = this.toQueryMap();
        if (!this.expansions.isEmpty()) {
            params.put("expand", this.expansions.stream().collect(Collectors.joining(",")));
        }
        String encodedPath = this.getEncodedPath();
        log.info("GET - path: {}, params: {}", (Object)encodedPath, params);
        String string = query = params != null && params.size() > 0 ? "?" : "";
        if (params != null) {
            for (String key : params.keySet()) {
                query = query + key + "=" + params.get(key) + "&";
            }
        }
        HttpGet httpGet = new HttpGet("https://api.hipchat.com/v2" + encodedPath + query);
        httpGet.addHeader((Header)new BasicHeader("Authorization", "Bearer " + this.accessToken));
        return this.httpClient.execute((HttpUriRequest)httpGet, (HttpContext)HttpClientContext.create());
    }

    public boolean addExpansion(String title) {
        return this.expansions.add(title);
    }

    public List<String> getExpansions() {
        return new ArrayList<String>(this.expansions);
    }
}

