/*
 * Decompiled with CFR 0.152.
 */
package io.evanwong.oss.hipchat.v2;

import io.evanwong.oss.hipchat.v2.emoticons.GetAllEmoticonsRequestBuilder;
import io.evanwong.oss.hipchat.v2.emoticons.GetEmoticonRequestBuilder;
import io.evanwong.oss.hipchat.v2.rooms.AddRoomMemberRequestBuilder;
import io.evanwong.oss.hipchat.v2.rooms.CreateRoomRequestBuilder;
import io.evanwong.oss.hipchat.v2.rooms.DeleteRoomRequestBuilder;
import io.evanwong.oss.hipchat.v2.rooms.GetAllRoomsRequestBuilder;
import io.evanwong.oss.hipchat.v2.rooms.GetRoomRequestBuilder;
import io.evanwong.oss.hipchat.v2.rooms.RemoveRoomMemberRequestBuilder;
import io.evanwong.oss.hipchat.v2.rooms.SendRoomNotificationRequestBuilder;
import io.evanwong.oss.hipchat.v2.rooms.SetTopicRequestBuilder;
import io.evanwong.oss.hipchat.v2.rooms.UpdateRoomRequestBuilder;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HipChatClient {
    private static final Logger log = LoggerFactory.getLogger(HipChatClient.class);
    private CloseableHttpClient httpClient;
    private ExecutorService executorService;
    private String defaultAccessToken;
    private int maxConnections = 20;
    private int maxConnectionsPerRoute = 4;

    public HipChatClient() {
        this.init();
    }

    public HipChatClient(String defaultAccessToken) {
        this.defaultAccessToken = defaultAccessToken;
        this.init();
    }

    private void init() {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(this.maxConnections);
        log.debug("Max pool size: {}", (Object)this.maxConnections);
        cm.setDefaultMaxPerRoute(this.maxConnectionsPerRoute);
        log.debug("Max per route: {}", (Object)this.maxConnectionsPerRoute);
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
        this.executorService = Executors.newFixedThreadPool(this.maxConnections);
    }

    public void setDefaultAccessToken(String defaultAccessToken) {
        this.defaultAccessToken = defaultAccessToken;
    }

    public GetAllRoomsRequestBuilder prepareGetAllRoomsRequestBuilder(String accessToken) {
        return new GetAllRoomsRequestBuilder(accessToken, (HttpClient)this.httpClient, this.executorService);
    }

    public GetAllRoomsRequestBuilder prepareGetAllRoomsRequestBuilder() {
        return this.prepareGetAllRoomsRequestBuilder(this.defaultAccessToken);
    }

    public SendRoomNotificationRequestBuilder prepareSendRoomNotificationRequestBuilder(String idOrName, String message, String accessToken) {
        return new SendRoomNotificationRequestBuilder(idOrName, message, accessToken, (HttpClient)this.httpClient, this.executorService);
    }

    public SendRoomNotificationRequestBuilder prepareSendRoomNotificationRequestBuilder(String idOrName, String message) {
        return this.prepareSendRoomNotificationRequestBuilder(idOrName, message, this.defaultAccessToken);
    }

    public CreateRoomRequestBuilder prepareCreateRoomRequestBuilder(String name, String accessToken) {
        return new CreateRoomRequestBuilder(name, accessToken, (HttpClient)this.httpClient, this.executorService);
    }

    public CreateRoomRequestBuilder prepareCreateRoomRequestBuilder(String name) {
        return this.prepareCreateRoomRequestBuilder(name, this.defaultAccessToken);
    }

    public GetRoomRequestBuilder prepareGetRoomRequestBuilder(String idOrName, String accessToken) {
        return new GetRoomRequestBuilder(idOrName, accessToken, (HttpClient)this.httpClient, this.executorService);
    }

    public GetRoomRequestBuilder prepareGetRoomRequestBuilder(String idOrName) {
        return this.prepareGetRoomRequestBuilder(idOrName, this.defaultAccessToken);
    }

    public GetEmoticonRequestBuilder prepareGetEmoticonRequestBuilder(String idOrShortcut) {
        return this.prepareGetEmoticonRequestBuilder(idOrShortcut);
    }

    public GetEmoticonRequestBuilder prepareGetEmoticonRequestBuilder(String idOrShortcut, String accessToken) {
        return new GetEmoticonRequestBuilder(idOrShortcut, accessToken, (HttpClient)this.httpClient, this.executorService);
    }

    public GetAllEmoticonsRequestBuilder prepareGetAllEmoticonsRequestBuilder() {
        return this.prepareGetAllEmoticonsRequestBuilder(this.defaultAccessToken);
    }

    public GetAllEmoticonsRequestBuilder prepareGetAllEmoticonsRequestBuilder(String accessToken) {
        return new GetAllEmoticonsRequestBuilder(accessToken, (HttpClient)this.httpClient, this.executorService);
    }

    public DeleteRoomRequestBuilder prepareDeleteRoomRequestBuilder(String roomIdOrName) {
        return this.prepareDeleteRoomRequestBuilder(roomIdOrName, this.defaultAccessToken);
    }

    public DeleteRoomRequestBuilder prepareDeleteRoomRequestBuilder(String roomIdOrName, String accessToken) {
        return new DeleteRoomRequestBuilder(roomIdOrName, accessToken, (HttpClient)this.httpClient, this.executorService);
    }

    public RemoveRoomMemberRequestBuilder prepareRemoveRoomMemberRequestBuilder(String userIdOrEmail, String roomIdOrName) {
        return this.prepareRemoveRoomMemberRequestBuilder(userIdOrEmail, roomIdOrName, this.defaultAccessToken);
    }

    public RemoveRoomMemberRequestBuilder prepareRemoveRoomMemberRequestBuilder(String userIdOrEmail, String roomIdOrName, String accessToken) {
        return new RemoveRoomMemberRequestBuilder(userIdOrEmail, roomIdOrName, accessToken, (HttpClient)this.httpClient, this.executorService);
    }

    public AddRoomMemberRequestBuilder prepareAddRoomMemberRequestBuilder(String userIdOrEmail, String roomIdOrName) {
        return this.prepareAddRoomMemberRequestBuilder(userIdOrEmail, roomIdOrName, this.defaultAccessToken);
    }

    public AddRoomMemberRequestBuilder prepareAddRoomMemberRequestBuilder(String userIdOrEmail, String roomIdOrName, String accessToken) {
        return new AddRoomMemberRequestBuilder(userIdOrEmail, roomIdOrName, accessToken, (HttpClient)this.httpClient, this.executorService);
    }

    public SetTopicRequestBuilder prepareSetTopicRequestBuilder(String roomIdOrName, String topic) {
        return this.prepareSetTopicRequestBuilder(roomIdOrName, topic, this.defaultAccessToken);
    }

    public SetTopicRequestBuilder prepareSetTopicRequestBuilder(String roomIdOrName, String topic, String accessToken) {
        return new SetTopicRequestBuilder(roomIdOrName, topic, accessToken, (HttpClient)this.httpClient, this.executorService);
    }

    public UpdateRoomRequestBuilder prepareUpdateRoomRequestBuilder(String roomIdOrName) {
        return this.prepareUpdateRoomRequestBuilder(roomIdOrName, this.defaultAccessToken);
    }

    public UpdateRoomRequestBuilder prepareUpdateRoomRequestBuilder(String roomIdOrName, String accessToken) {
        return new UpdateRoomRequestBuilder(roomIdOrName, accessToken, (HttpClient)this.httpClient, this.executorService);
    }

    public void close() {
        log.info("Shutting down...");
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            log.error("Failed to close the HttpClient.", (Throwable)e);
        }
        this.executorService.shutdown();
    }
}

