/*
 * Decompiled with CFR 0.152.
 */
package io.epirus.web3j.gas;

import com.github.stefanbirkner.systemlambda.SystemLambda;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import io.epirus.web3j.HttpMockedTest;
import io.epirus.web3j.gas.EpirusGasProvider;
import io.epirus.web3j.gas.GasPrice;
import java.math.BigInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.web3j.protocol.Network;

public class EpirusGasProviderTest
extends HttpMockedTest {
    @Test
    public void testEpirusPlatformWorksAgainstMock() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/gas/price")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"application/json"}).withBody("{\n  \"safeLow\": 3,\n  \"gasPrice\": 2,\n  \"high\": 1\n}")));
        SystemLambda.withEnvironmentVariable((String)"EPIRUS_LOGIN_TOKEN", (String)"token").execute(() -> {
            EpirusGasProvider provider = new EpirusGasProvider(Network.RINKEBY, String.format("%s/gas/price", wireMockServer.baseUrl()), GasPrice.High);
            Assertions.assertEquals((Object)provider.getGasPrice(), (Object)BigInteger.ONE);
        });
    }

    @Test
    @Disabled(value="requires the CLI to be logged in to pass")
    public void testEpirusPlatformGasProviderWorks() throws Exception {
        EpirusGasProvider provider = new EpirusGasProvider(Network.RINKEBY, GasPrice.High);
        Assertions.assertEquals((int)provider.getGasPrice().compareTo(BigInteger.ONE), (int)1);
        Assertions.assertNotEquals((Object)provider.getGasPrice(), (Object)BigInteger.valueOf(4100000000L));
    }
}

