package io.eosnova.wallet.android.sdk.utils

import android.content.Context
import android.content.Intent
import android.net.Uri
import android.os.Build
import android.util.Log
import io.eosnova.wallet.android.sdk.BuildConfig

/**
 * Created by shinhyo.
 */
object Utils {

    const val TAG = "NovaSDK"
    const val NOVA_WALLET_PACKAGE_NAME = "io.eosnova.wallet.android"

    const val MIN_WALLET_VERSION = 136

    /*
    # SDK Version: 2.0.0 (10) - Min NovaWallet VersionCode: 136
     */

    fun isInstalled(context: Context, packageName: String): Boolean {
        try {
            context.packageManager.getPackageInfo(packageName, 0)
        } catch (e: Exception) {
            return false
        }
        return true
    }

    fun checkMinNovaWalletVersion(context: Context): Boolean {
        val walletVersion = getNovaWalletVersionCode(context)
        var isMinVersion = walletVersion >= MIN_WALLET_VERSION
        Log.d(TAG, "NovaWallet Min Versioin Check >> NovaWallet: $walletVersion, SDK Min: $MIN_WALLET_VERSION")
        return isMinVersion
    }

    fun getNovaWalletVersionCode(context: Context): Long {
        var versionCode = -1L
        try {
            val pkgInfo = context.packageManager.getPackageInfo(NOVA_WALLET_PACKAGE_NAME, 0)
            versionCode = if (Build.VERSION.SDK_INT >= 28)
                pkgInfo.longVersionCode else pkgInfo.versionCode.toLong()
        } catch (e: Exception) {

        }
        return versionCode
    }

    fun goStore(context: Context, pkgName: String = BuildConfig.LIBRARY_PACKAGE_NAME) {
        try {
            val intent = Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=$pkgName"))
            intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK)
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
            context.startActivity(intent)
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }
}