package io.eosnova.wallet.android.sdk.utils

import android.content.BroadcastReceiver
import android.content.IntentFilter
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.Lifecycle
import androidx.lifecycle.LifecycleObserver
import androidx.lifecycle.OnLifecycleEvent

/**
 * Created by shinhyo.
 */
class AutoClearedBroadcast(private val lifecycle: Lifecycle, private val activity: AppCompatActivity,
                           private val receiver: BroadcastReceiver
) : LifecycleObserver {

    fun add(action: String) {
        val filter = IntentFilter(action)
        filter.priority = 1000
        activity.registerReceiver(receiver, filter)
    }

    @OnLifecycleEvent(Lifecycle.Event.ON_DESTROY)
    fun detachSelf() {
        try {
            activity.unregisterReceiver(receiver)
            lifecycle.removeObserver(this)
        } catch (e: Exception) {
        }
    }
}