package io.eosnova.wallet.android.sdk.model.eos

import com.google.gson.JsonObject
import io.eosnova.wallet.android.sdk.Chain
import io.eosnova.wallet.android.sdk.model.Action
import java.math.BigDecimal
import java.util.*

/**
 * Created by shinhyo.
 */
class EosTransfer(val from: String, var to: String, var contract: String = "eosio.token") {
    var amount: BigDecimal = 0.toBigDecimal()
    var precision: Int = 4
    var symbol: String = Chain.EOS.name.toUpperCase(Locale.ENGLISH)
    var memo: String? = null

    internal fun toAction(): Action {
        if (precision < 0) {
            precision = 0
        }

        val action = Action()
        action.contract = contract
        action.account = from
        action.action = "transfer"
        action.args = JsonObject().apply {
            addProperty("from", from)
            addProperty("to", to)
            addProperty("quantity", String.format("%.${precision}f $symbol", amount))
            addProperty("memo", memo)
        }.toString()

        return action
    }
}