package io.eosnova.wallet.android.sdk.model.eos

import com.google.gson.JsonObject
import io.eosnova.wallet.android.sdk.model.Action
import java.math.BigDecimal

/**
 * Created by shinhyo.
 */
class EosStake(private val from: String, private val to: String) {

    var action: Stake = Stake.STAKE

    var cpu: BigDecimal = 0.00.toBigDecimal()
    var net: BigDecimal = 0.00.toBigDecimal()
    var transfer: Boolean = false

    internal fun toAction(): Action {
        val novaAction = Action()
        novaAction.contract = "eosio"
        novaAction.account = from
        novaAction.action = action.value
        novaAction.args = JsonObject().apply {
            addProperty("from", from)
            addProperty("receiver", to)
            when (novaAction.action) {
                Stake.STAKE.value -> {
                    addProperty("stake_cpu_quantity", String.format("%.${4}f EOS", cpu))
                    addProperty("stake_net_quantity", String.format("%.${4}f EOS", net))
                }
                Stake.UNSTAKE.value -> {
                    addProperty("unstake_cpu_quantity", String.format("%.${4}f EOS", cpu))
                    addProperty("unstake_net_quantity", String.format("%.${4}f EOS", net))
                }
            }

            addProperty("transfer", transfer)
        }.toString()
        return novaAction
    }

    enum class Stake(val value: String) {
        STAKE("delegatebw"), UNSTAKE("undelegatebw")
    }

}