package io.eosnova.wallet.android.sdk

import android.app.Activity
import io.eosnova.wallet.android.sdk.model.Action
import io.eosnova.wallet.android.sdk.model.klaytn.KlaytnTransfer

/**
 * Created by shinhyo.
 */
class NovaKlaytnAuth(activity: Activity) : BaseAuth(activity) {

    override val chain: Chain
        get() = Chain.KLAY

    // to
    fun requestAccount() = send("account")

    fun sendTransfer(transfer: KlaytnTransfer) {
        send("transaction", gson.toJson(ArrayList<Action>().apply { add(transfer.toAction()) }))
    }

//    fun sendValueTransferTransaction(transaction: ValueTransferTransaction) {
//        send("transaction_value_transfer", gson.toJson(transaction))
//    }
//
//    fun sendSmartContractExecutionTransaction(transaction: Function) {
//        send("transaction_smart_contract_execution", gson.toJson(transaction))
//    }

//    fun requestTransaction(activity: Activity, action: List<Action>) {
//        if (chkInit(activity) || action.isEmpty()) return
//        send(activity, "transaction", Gson().toJson(action))
//    }
}
