package io.eosnova.wallet.android.sdk

import android.app.Activity
import io.eosnova.wallet.android.sdk.model.Action
import io.eosnova.wallet.android.sdk.model.eos.EosSignature
import io.eosnova.wallet.android.sdk.model.eos.EosStake
import io.eosnova.wallet.android.sdk.model.eos.EosTransfer

/**
 * Created by shinhyo.
 */
class NovaEosAuth(activity: Activity) : BaseAuth(activity) {

    override val chain: Chain
        get() = Chain.EOS

    // to
    fun requestAccount() = send("account")

    // transaction
    fun requestTransfer(transfer: EosTransfer) = requestTransaction(transfer.toAction())

    fun requestStake(stake: EosStake) = requestTransaction(stake.toAction())

    fun requestTransaction(action: Action) {
        requestTransaction(ArrayList<Action>().apply { add(action) })
    }

    fun requestTransaction(action: List<Action>) {
        if (action.isEmpty()) return
        send("transaction", gson.toJson(action))
    }

    // signature
    fun requestSignature(signature: EosSignature) = send("signature", gson.toJson(signature))


}
