package io.eosnova.wallet.android.sdk.model.klaytn

import com.google.gson.JsonObject
import io.eosnova.wallet.android.sdk.Chain
import io.eosnova.wallet.android.sdk.exception.NovaInputValueException
import io.eosnova.wallet.android.sdk.model.Action
import java.math.BigDecimal
import java.math.BigInteger
import java.util.*

/**
 * Created by shinhyo.
 */
class KlaytnTransfer(var from: String, var to: String) {

    var contract: String = "0x8d12A197cB00D4747a1fe03395095ce2A5CC6819"
    var amount: BigDecimal = 0.toBigDecimal()
    var symbol: String = ""
    var decimal: Int = 18
    var memo: String = ""
    var gasLimit: BigInteger = 100000.toBigInteger()

    companion object {

        @JvmStatic
        fun createKlaytnTransfer(from: String, to: String, amount: BigDecimal, memo: String = ""): KlaytnTransfer {
            val transfer = KlaytnTransfer(from, to)
            transfer.amount = amount
            transfer.memo = memo
            transfer.symbol = Chain.KLAY.name.toUpperCase(Locale.ENGLISH)

            if(transfer.amount <= BigDecimal.ZERO) {
                throw NovaInputValueException("Transfer \'amount' must be over 0.")
            }

            return transfer
        }

        @JvmStatic
        fun createSmartContractTransfer(from: String, to: String, contract: String, symbol: String, decimal: Int, amount: BigDecimal): KlaytnTransfer {
            val transfer = KlaytnTransfer(from, to)
            transfer.contract = contract
            transfer.decimal = decimal
            transfer.symbol = symbol
            transfer.amount = amount

            if(transfer.decimal <= 0) {
                throw NovaInputValueException("Transfer \'decimal' must be over 0.")
            }
            if(transfer.amount <= BigDecimal.ZERO) {
                throw NovaInputValueException("Transfer \'amount' must be over 0.")
            }

            return transfer
        }
    }

    internal fun toAction(): Action {
        if (decimal < 0) {
            decimal = 0
        }

        val action = Action()
        action.contract = contract
        action.account = from
        action.action = "Transfer"
        action.args = JsonObject().apply {
            addProperty("to", to)
            addProperty("decimal", decimal)
            addProperty("symbol", symbol)
            addProperty("amount", amount)
            addProperty("gas_limit", gasLimit)

            if (memo.isNotEmpty() && isKlay()) {
                addProperty("memo", memo)
            }
        }.toString()
        return action
    }

    private fun isKlay() = contract == "0x8d12A197cB00D4747a1fe03395095ce2A5CC6819"

}