package io.eosnova.wallet.android.sdk

/**
 * Created by BaeHyunChul.
 * Date : 2019. 10. 24.
 * Time : 09:59
 */
class NovaSdkResult(val code: Int, val message: String) {
    /*
        0 : success

        100: User pressed 'cancel' button
        101: Parameter of your request is wrong

        200: Account list empty in nova.
        201: Can't find account in nova.
        202: Can't find account in chain.
        203: Unknown chain type.

        300: Fail to push transaction.
        400: Fail signature.

        500: User back to dapp without any action
        501: Not use yet.
     */

    object ResultCode {
        const val SUCCESS = 0

        const val CANCEL = 100
        const val REQUEST_PARAM_WRONG = 101

        const val EMPTY_ACCOUNT = 200
        const val NOT_FOUND_ACCOUNT_IN_NOVA = 201
        const val NOT_FOUND_ACCOUNT_IN_CHAIN = 202
        const val UNKNOWN_CHAIN_TYPE = 203

        const val FAIL_TRANSACTION = 300
        const val FAIL_SIGNATURE = 400

        const val USER_BACK_DAPP = 500
        const val NOT_USE = 501
    }

    companion object {
        /* Success */
        val SUCCESS = NovaSdkResult(ResultCode.SUCCESS, "Success")

        /* Error */
        val CANCEL = NovaSdkResult(ResultCode.CANCEL, "User pressed 'cancel' button")
        val REQUEST_PARAM_WRONG = NovaSdkResult(ResultCode.REQUEST_PARAM_WRONG, "Parameter of your request is wrong")

        val EMPTY_ACCOUNT = NovaSdkResult(ResultCode.EMPTY_ACCOUNT, "Account list empty in nova.")
        val NOT_FOUND_ACCOUNT_IN_NOVA = NovaSdkResult(ResultCode.NOT_FOUND_ACCOUNT_IN_NOVA, "Can't find account in nova.")
        val NOT_FOUND_ACCOUNT_IN_CHAIN = NovaSdkResult(ResultCode.NOT_FOUND_ACCOUNT_IN_CHAIN, "Can't find account in chain.")
        val UNKNOWN_CHAIN_TYPE = NovaSdkResult(ResultCode.UNKNOWN_CHAIN_TYPE, "Unknown chain type.")

        val FAIL_TRANSACTION = NovaSdkResult(ResultCode.FAIL_TRANSACTION, "Fail to push transaction.")
        val FAIL_SIGNATURE = NovaSdkResult(ResultCode.FAIL_SIGNATURE, "Fail signature.")

        val USER_BACK_DAPP = NovaSdkResult(ResultCode.USER_BACK_DAPP, "User back to dapp without any action")
        val NOT_USE = NovaSdkResult(ResultCode.NOT_USE, "Not use yet")
    }

}