/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.controlplane.server;

import io.envoyproxy.controlplane.cache.DeltaWatch;
import io.envoyproxy.controlplane.cache.Resources;
import io.envoyproxy.controlplane.server.DeltaDiscoveryRequestStreamObserver;
import io.envoyproxy.controlplane.server.DiscoveryServer;
import io.envoyproxy.controlplane.server.LatestDeltaDiscoveryResponse;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public class XdsDeltaDiscoveryRequestStreamObserver<V, X, Y>
extends DeltaDiscoveryRequestStreamObserver<V, X, Y> {
    private final Map<String, String> trackedResources = new HashMap<String, String>();
    private final Set<String> pendingResources = new HashSet<String>();
    private final boolean isWildcard;
    private final ConcurrentMap<String, LatestDeltaDiscoveryResponse> responses;
    private volatile DeltaWatch watch;
    private volatile String latestVersion;

    XdsDeltaDiscoveryRequestStreamObserver(String defaultTypeUrl, StreamObserver<X> responseObserver, long streamId, Executor executor, DiscoveryServer<?, ?, V, X, Y> discoveryServer) {
        super(defaultTypeUrl, responseObserver, streamId, executor, discoveryServer);
        Resources.ResourceType resourceType = (Resources.ResourceType)Resources.TYPE_URLS_TO_RESOURCE_TYPE.get(defaultTypeUrl);
        this.isWildcard = Resources.ResourceType.CLUSTER.equals((Object)resourceType) || Resources.ResourceType.LISTENER.equals((Object)resourceType);
        this.responses = new ConcurrentHashMap<String, LatestDeltaDiscoveryResponse>();
    }

    @Override
    void cancel() {
        if (this.watch != null) {
            this.watch.cancel();
        }
    }

    @Override
    boolean ads() {
        return false;
    }

    @Override
    void setLatestVersion(String typeUrl, String version) {
        this.latestVersion = version;
    }

    @Override
    String latestVersion(String typeUrl) {
        return this.latestVersion;
    }

    @Override
    void setResponse(String typeUrl, String nonce, LatestDeltaDiscoveryResponse response) {
        this.responses.put(nonce, response);
    }

    @Override
    LatestDeltaDiscoveryResponse clearResponse(String typeUrl, String nonce) {
        return (LatestDeltaDiscoveryResponse)this.responses.remove(nonce);
    }

    @Override
    int responseCount(String typeUrl) {
        return this.responses.size();
    }

    @Override
    Map<String, String> resourceVersions(String typeUrl) {
        return this.trackedResources;
    }

    @Override
    Set<String> pendingResources(String typeUrl) {
        return this.pendingResources;
    }

    @Override
    boolean isWildcard(String typeUrl) {
        return this.isWildcard;
    }

    @Override
    void updateTrackedResources(String typeUrl, Map<String, String> resourcesVersions, List<String> removedResources) {
        resourcesVersions.forEach((k, v) -> {
            this.trackedResources.put((String)k, (String)v);
            this.pendingResources.remove(k);
        });
        removedResources.forEach(this.trackedResources::remove);
    }

    @Override
    void updateSubscriptions(String typeUrl, List<String> resourceNamesSubscribe, List<String> resourceNamesUnsubscribe) {
        resourceNamesUnsubscribe.forEach(s -> {
            this.trackedResources.remove(s);
            this.pendingResources.remove(s);
        });
        this.pendingResources.addAll(resourceNamesSubscribe);
    }

    @Override
    void computeWatch(String typeUrl, Supplier<DeltaWatch> watchCreator) {
        this.cancel();
        this.watch = watchCreator.get();
    }
}

