/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.controlplane.server;

import com.google.common.base.Strings;
import com.google.protobuf.Any;
import io.envoyproxy.controlplane.cache.Resources;
import io.envoyproxy.controlplane.cache.Response;
import io.envoyproxy.controlplane.cache.Watch;
import io.envoyproxy.controlplane.cache.XdsRequest;
import io.envoyproxy.controlplane.server.DiscoveryServer;
import io.envoyproxy.controlplane.server.LatestDiscoveryResponse;
import io.envoyproxy.controlplane.server.exception.RequestException;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DiscoveryRequestStreamObserver<T, U>
implements StreamObserver<T> {
    private static final AtomicLongFieldUpdater<DiscoveryRequestStreamObserver> streamNonceUpdater = AtomicLongFieldUpdater.newUpdater(DiscoveryRequestStreamObserver.class, "streamNonce");
    private static final Logger LOGGER = LoggerFactory.getLogger(DiscoveryServer.class);
    final long streamId;
    final DiscoveryServer<T, U, ?, ?, ?> discoveryServer;
    private final String defaultTypeUrl;
    private final StreamObserver<U> responseObserver;
    private final Executor executor;
    volatile boolean hasClusterChanged;
    private volatile long streamNonce;
    private volatile boolean isClosing;

    DiscoveryRequestStreamObserver(String defaultTypeUrl, StreamObserver<U> responseObserver, long streamId, Executor executor, DiscoveryServer<T, U, ?, ?, ?> discoveryServer) {
        this.defaultTypeUrl = defaultTypeUrl;
        this.responseObserver = responseObserver;
        this.streamId = streamId;
        this.executor = executor;
        this.streamNonce = 0L;
        this.discoveryServer = discoveryServer;
        this.hasClusterChanged = false;
    }

    public void onNext(T rawRequest) {
        String resourceNonce;
        XdsRequest request = this.discoveryServer.wrapXdsRequest(rawRequest);
        String requestTypeUrl = request.getTypeUrl().isEmpty() ? this.defaultTypeUrl : request.getTypeUrl();
        String nonce = request.getResponseNonce();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[{}] request {}[{}] with nonce {} from version {}", new Object[]{this.streamId, requestTypeUrl, String.join((CharSequence)", ", (Iterable<? extends CharSequence>)request.getResourceNamesList()), nonce, request.getVersionInfo()});
        }
        try {
            this.discoveryServer.runStreamRequestCallbacks(this.streamId, rawRequest);
        }
        catch (RequestException e) {
            this.onError((Throwable)((Object)e));
            return;
        }
        LatestDiscoveryResponse latestDiscoveryResponse = this.latestResponse(requestTypeUrl);
        String string = resourceNonce = latestDiscoveryResponse == null ? null : latestDiscoveryResponse.nonce();
        if (Strings.isNullOrEmpty((String)resourceNonce) || resourceNonce.equals(nonce)) {
            if (!request.hasErrorDetail() && latestDiscoveryResponse != null) {
                this.setAckedResources(requestTypeUrl, latestDiscoveryResponse.resourceNames());
            }
            this.computeWatch(requestTypeUrl, () -> this.discoveryServer.configWatcher.createWatch(this.ads(), request, this.ackedResources(requestTypeUrl), r -> this.executor.execute(() -> this.send((Response)r, requestTypeUrl)), this.hasClusterChanged, this.discoveryServer.startupConfigs().allowDefaultEmptyEdsUpdate()));
        }
    }

    public void onError(Throwable t) {
        if (!Status.fromThrowable((Throwable)t).getCode().equals((Object)Status.CANCELLED.getCode())) {
            LOGGER.error("[{}] stream closed with error", (Object)this.streamId, (Object)t);
        }
        try {
            this.discoveryServer.callbacks.forEach(cb -> cb.onStreamCloseWithError(this.streamId, this.defaultTypeUrl, t));
            this.closeWithError((Throwable)Status.fromThrowable((Throwable)t).asException());
        }
        finally {
            this.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCompleted() {
        LOGGER.debug("[{}] stream closed", (Object)this.streamId);
        try {
            this.discoveryServer.callbacks.forEach(cb -> cb.onStreamClose(this.streamId, this.defaultTypeUrl));
            StreamObserver<U> streamObserver = this.responseObserver;
            synchronized (streamObserver) {
                if (!this.isClosing) {
                    this.isClosing = true;
                    this.responseObserver.onCompleted();
                }
            }
        }
        finally {
            this.cancel();
        }
    }

    void onCancelled() {
        LOGGER.info("[{}] stream cancelled", (Object)this.streamId);
        this.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeWithError(Throwable exception) {
        StreamObserver<U> streamObserver = this.responseObserver;
        synchronized (streamObserver) {
            if (!this.isClosing) {
                this.isClosing = true;
                this.responseObserver.onError(exception);
            }
        }
        this.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(Response response, String typeUrl) {
        String nonce = Long.toString(streamNonceUpdater.getAndIncrement(this));
        Collection<Any> resources = this.discoveryServer.protoResourcesSerializer.serialize(response.resources(), Resources.getResourceApiVersion((String)typeUrl));
        LOGGER.debug("[{}] response {} with nonce {} version {}", new Object[]{this.streamId, typeUrl, nonce, response.version()});
        U discoveryResponse = this.discoveryServer.makeResponse(response.version(), resources, typeUrl, nonce);
        this.discoveryServer.runStreamResponseCallbacks(this.streamId, response.request(), discoveryResponse);
        this.setLatestResponse(typeUrl, LatestDiscoveryResponse.create(nonce, response.resources().stream().map(Resources::getResourceName).collect(Collectors.toSet())));
        StreamObserver<U> streamObserver = this.responseObserver;
        synchronized (streamObserver) {
            block6: {
                if (!this.isClosing) {
                    try {
                        this.responseObserver.onNext(discoveryResponse);
                    }
                    catch (StatusRuntimeException e) {
                        if (Status.CANCELLED.getCode().equals((Object)e.getStatus().getCode())) break block6;
                        throw e;
                    }
                }
            }
        }
    }

    abstract void cancel();

    abstract boolean ads();

    abstract LatestDiscoveryResponse latestResponse(String var1);

    abstract void setLatestResponse(String var1, LatestDiscoveryResponse var2);

    abstract Set<String> ackedResources(String var1);

    abstract void setAckedResources(String var1, Set<String> var2);

    abstract void computeWatch(String var1, Supplier<Watch> var2);
}

