/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.controlplane.server;

import io.envoyproxy.controlplane.cache.AbstractWatch;
import io.envoyproxy.controlplane.cache.DeltaWatch;
import io.envoyproxy.controlplane.cache.Resources;
import io.envoyproxy.controlplane.server.DeltaDiscoveryRequestStreamObserver;
import io.envoyproxy.controlplane.server.DiscoveryServer;
import io.envoyproxy.controlplane.server.LatestDeltaDiscoveryResponse;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public class AdsDeltaDiscoveryRequestStreamObserver<V, X, Y>
extends DeltaDiscoveryRequestStreamObserver<V, X, Y> {
    private final ConcurrentMap<String, DeltaWatch> watches = new ConcurrentHashMap<String, DeltaWatch>(Resources.V3.TYPE_URLS.size());
    private final ConcurrentMap<String, String> latestVersion = new ConcurrentHashMap<String, String>(Resources.V3.TYPE_URLS.size());
    private final ConcurrentMap<String, ConcurrentHashMap<String, LatestDeltaDiscoveryResponse>> responses = new ConcurrentHashMap<String, ConcurrentHashMap<String, LatestDeltaDiscoveryResponse>>(Resources.V3.TYPE_URLS.size());
    private final Map<String, Map<String, String>> trackedResourceMap = new HashMap<String, Map<String, String>>(Resources.V3.TYPE_URLS.size());
    private final Map<String, Set<String>> pendingResourceMap = new HashMap<String, Set<String>>(Resources.V3.TYPE_URLS.size());

    AdsDeltaDiscoveryRequestStreamObserver(StreamObserver<X> responseObserver, long streamId, Executor executor, DiscoveryServer<?, ?, V, X, Y> discoveryServer) {
        super("", responseObserver, streamId, executor, discoveryServer);
    }

    @Override
    public void onNext(V request) {
        if (this.discoveryServer.wrapDeltaXdsRequest(request).getTypeUrl().isEmpty()) {
            this.closeWithError((Throwable)Status.UNKNOWN.withDescription(String.format("[%d] type URL is required for ADS", this.streamId)).asRuntimeException());
            return;
        }
        super.onNext(request);
    }

    @Override
    void cancel() {
        this.watches.values().forEach(AbstractWatch::cancel);
    }

    @Override
    boolean ads() {
        return true;
    }

    @Override
    void setLatestVersion(String typeUrl, String version) {
        this.latestVersion.put(typeUrl, version);
        if (typeUrl.equals("type.googleapis.com/envoy.config.cluster.v3.Cluster")) {
            this.hasClusterChanged = true;
        } else if (typeUrl.equals("type.googleapis.com/envoy.config.endpoint.v3.ClusterLoadAssignment")) {
            this.hasClusterChanged = false;
        }
    }

    @Override
    String latestVersion(String typeUrl) {
        return (String)this.latestVersion.get(typeUrl);
    }

    @Override
    void setResponse(String typeUrl, String nonce, LatestDeltaDiscoveryResponse response) {
        this.responses.computeIfAbsent(typeUrl, s -> new ConcurrentHashMap()).put(nonce, response);
    }

    @Override
    LatestDeltaDiscoveryResponse clearResponse(String typeUrl, String nonce) {
        return (LatestDeltaDiscoveryResponse)this.responses.computeIfAbsent(typeUrl, s -> new ConcurrentHashMap()).remove(nonce);
    }

    @Override
    int responseCount(String typeUrl) {
        return this.responses.computeIfAbsent(typeUrl, s -> new ConcurrentHashMap()).size();
    }

    @Override
    Map<String, String> resourceVersions(String typeUrl) {
        return this.trackedResourceMap.getOrDefault(typeUrl, Collections.emptyMap());
    }

    @Override
    Set<String> pendingResources(String typeUrl) {
        return this.pendingResourceMap.getOrDefault(typeUrl, Collections.emptySet());
    }

    @Override
    boolean isWildcard(String typeUrl) {
        Resources.ResourceType resourceType = (Resources.ResourceType)Resources.TYPE_URLS_TO_RESOURCE_TYPE.get(typeUrl);
        return Resources.ResourceType.CLUSTER.equals((Object)resourceType) || Resources.ResourceType.LISTENER.equals((Object)resourceType);
    }

    @Override
    void updateTrackedResources(String typeUrl, Map<String, String> resourcesVersions, List<String> removedResources) {
        Map trackedResources = this.trackedResourceMap.computeIfAbsent(typeUrl, s -> new HashMap());
        Set pendingResources = this.pendingResourceMap.computeIfAbsent(typeUrl, s -> new HashSet());
        resourcesVersions.forEach((k, v) -> {
            trackedResources.put(k, v);
            pendingResources.remove(k);
        });
        removedResources.forEach(trackedResources::remove);
    }

    @Override
    void updateSubscriptions(String typeUrl, List<String> resourceNamesSubscribe, List<String> resourceNamesUnsubscribe) {
        Map trackedResources = this.trackedResourceMap.computeIfAbsent(typeUrl, s -> new HashMap());
        Set pendingResources = this.pendingResourceMap.computeIfAbsent(typeUrl, s -> new HashSet());
        resourceNamesUnsubscribe.forEach(s -> {
            trackedResources.remove(s);
            pendingResources.remove(s);
        });
        pendingResources.addAll(resourceNamesSubscribe);
    }

    @Override
    void computeWatch(String typeUrl, Supplier<DeltaWatch> watchCreator) {
        this.watches.compute(typeUrl, (s, watch) -> {
            if (watch != null) {
                watch.cancel();
            }
            return (DeltaWatch)watchCreator.get();
        });
    }
}

