/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.controlplane.server;

import com.google.common.base.Preconditions;
import com.google.protobuf.Any;
import io.envoyproxy.controlplane.cache.ConfigWatcher;
import io.envoyproxy.controlplane.cache.DeltaXdsRequest;
import io.envoyproxy.controlplane.cache.XdsRequest;
import io.envoyproxy.controlplane.server.AdsDeltaDiscoveryRequestStreamObserver;
import io.envoyproxy.controlplane.server.AdsDiscoveryRequestStreamObserver;
import io.envoyproxy.controlplane.server.DeltaDiscoveryRequestStreamObserver;
import io.envoyproxy.controlplane.server.DiscoveryRequestStreamObserver;
import io.envoyproxy.controlplane.server.DiscoveryServerCallbacks;
import io.envoyproxy.controlplane.server.ExecutorGroup;
import io.envoyproxy.controlplane.server.XdsDeltaDiscoveryRequestStreamObserver;
import io.envoyproxy.controlplane.server.XdsDiscoveryRequestStreamObserver;
import io.envoyproxy.controlplane.server.serializer.ProtoResourcesSerializer;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DiscoveryServer<T, U, V, X, Y> {
    static final String ANY_TYPE_URL = "";
    private static final Logger LOGGER = LoggerFactory.getLogger(DiscoveryServer.class);
    final List<DiscoveryServerCallbacks> callbacks;
    final ConfigWatcher configWatcher;
    final ProtoResourcesSerializer protoResourcesSerializer;
    private final ExecutorGroup executorGroup;
    private final AtomicLong streamCount = new AtomicLong();

    protected DiscoveryServer(List<DiscoveryServerCallbacks> callbacks, ConfigWatcher configWatcher, ExecutorGroup executorGroup, ProtoResourcesSerializer protoResourcesSerializer) {
        Preconditions.checkNotNull((Object)executorGroup, (Object)"executorGroup cannot be null");
        Preconditions.checkNotNull(callbacks, (Object)"callbacks cannot be null");
        Preconditions.checkNotNull((Object)configWatcher, (Object)"configWatcher cannot be null");
        Preconditions.checkNotNull((Object)protoResourcesSerializer, (Object)"protoResourcesSerializer cannot be null");
        this.callbacks = callbacks;
        this.configWatcher = configWatcher;
        this.protoResourcesSerializer = protoResourcesSerializer;
        this.executorGroup = executorGroup;
    }

    protected abstract XdsRequest wrapXdsRequest(T var1);

    protected abstract DeltaXdsRequest wrapDeltaXdsRequest(V var1);

    protected abstract U makeResponse(String var1, Collection<Any> var2, String var3, String var4);

    public abstract X makeDeltaResponse(String var1, String var2, String var3, List<Y> var4, List<String> var5);

    protected abstract Y makeResource(String var1, String var2, Any var3);

    protected abstract void runStreamRequestCallbacks(long var1, T var3);

    protected abstract void runStreamDeltaRequestCallbacks(long var1, V var3);

    protected abstract void runStreamResponseCallbacks(long var1, XdsRequest var3, U var4);

    protected abstract void runStreamDeltaResponseCallbacks(long var1, DeltaXdsRequest var3, X var4);

    StreamObserver<T> createRequestHandler(StreamObserver<U> responseObserver, boolean ads, String defaultTypeUrl) {
        long streamId = this.streamCount.getAndIncrement();
        Executor executor = this.executorGroup.next();
        LOGGER.debug("[{}] open stream from {}", (Object)streamId, (Object)defaultTypeUrl);
        this.callbacks.forEach(cb -> cb.onStreamOpen(streamId, defaultTypeUrl));
        DiscoveryRequestStreamObserver requestStreamObserver = ads ? new AdsDiscoveryRequestStreamObserver(responseObserver, streamId, executor, this) : new XdsDiscoveryRequestStreamObserver(defaultTypeUrl, responseObserver, streamId, executor, this);
        if (responseObserver instanceof ServerCallStreamObserver) {
            ((ServerCallStreamObserver)responseObserver).setOnCancelHandler(requestStreamObserver::onCancelled);
        }
        return requestStreamObserver;
    }

    StreamObserver<V> createDeltaRequestHandler(StreamObserver<X> responseObserver, boolean ads, String defaultTypeUrl) {
        long streamId = this.streamCount.getAndIncrement();
        Executor executor = this.executorGroup.next();
        LOGGER.debug("[{}] open stream from {}", (Object)streamId, (Object)defaultTypeUrl);
        this.callbacks.forEach(cb -> cb.onStreamOpen(streamId, defaultTypeUrl));
        DeltaDiscoveryRequestStreamObserver requestStreamObserver = ads ? new AdsDeltaDiscoveryRequestStreamObserver(responseObserver, streamId, executor, this) : new XdsDeltaDiscoveryRequestStreamObserver(defaultTypeUrl, responseObserver, streamId, executor, this);
        if (responseObserver instanceof ServerCallStreamObserver) {
            ((ServerCallStreamObserver)responseObserver).setOnCancelHandler(requestStreamObserver::onCancelled);
        }
        return requestStreamObserver;
    }
}

