/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.controlplane.server.serializer;

import com.google.protobuf.Any;
import com.google.protobuf.Message;
import io.envoyproxy.controlplane.cache.Resources;
import io.envoyproxy.controlplane.server.serializer.ProtoResourcesSerializer;

public class DefaultProtoResourcesSerializer
implements ProtoResourcesSerializer {
    @Override
    public Any serialize(Message resource, Resources.ApiVersion apiVersion) {
        Any output = Any.pack((Message)resource);
        return this.maybeRewriteTypeUrl(output, apiVersion);
    }

    protected Any maybeRewriteTypeUrl(Any output, Resources.ApiVersion apiVersion) {
        if (Resources.getResourceApiVersion((String)output.getTypeUrl()) == apiVersion) {
            return output;
        }
        switch (apiVersion) {
            case V2: {
                return output.toBuilder().setTypeUrl((String)Resources.V3_TYPE_URLS_TO_V2.get(output.getTypeUrl())).build();
            }
            case V3: {
                return output.toBuilder().setTypeUrl((String)Resources.V2_TYPE_URLS_TO_V3.get(output.getTypeUrl())).build();
            }
        }
        throw new RuntimeException(String.format("Unsupported API version %s", apiVersion));
    }
}

