/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.controlplane.server.serializer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import io.envoyproxy.controlplane.cache.Resources;
import io.envoyproxy.controlplane.server.serializer.DefaultProtoResourcesSerializer;
import io.envoyproxy.controlplane.server.serializer.ProtoResourcesSerializer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class CachedProtoResourcesSerializer
extends DefaultProtoResourcesSerializer {
    private static final Map<Resources.ApiVersion, Cache<Message, Any>> caches = new HashMap<Resources.ApiVersion, Cache<Message, Any>>(){
        {
            this.put(Resources.ApiVersion.V2, CacheBuilder.newBuilder().weakValues().build());
            this.put(Resources.ApiVersion.V3, CacheBuilder.newBuilder().weakValues().build());
        }
    };

    @Override
    public Any serialize(Message resource, Resources.ApiVersion apiVersion) {
        try {
            return (Any)caches.get(apiVersion).get((Object)resource, () -> super.maybeRewriteTypeUrl(Any.pack((Message)resource), apiVersion));
        }
        catch (ExecutionException e) {
            throw new ProtoResourcesSerializer.ProtoSerializerException("Error while serializing resources", e);
        }
    }
}

