/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.controlplane.server;

import com.google.common.base.Preconditions;
import com.google.protobuf.Any;
import io.envoyproxy.controlplane.cache.ConfigWatcher;
import io.envoyproxy.controlplane.cache.XdsRequest;
import io.envoyproxy.controlplane.server.DefaultExecutorGroup;
import io.envoyproxy.controlplane.server.DiscoveryServer;
import io.envoyproxy.controlplane.server.DiscoveryServerCallbacks;
import io.envoyproxy.controlplane.server.ExecutorGroup;
import io.envoyproxy.controlplane.server.serializer.DefaultProtoResourcesSerializer;
import io.envoyproxy.controlplane.server.serializer.ProtoResourcesSerializer;
import io.envoyproxy.envoy.service.cluster.v3.ClusterDiscoveryServiceGrpc;
import io.envoyproxy.envoy.service.discovery.v3.AggregatedDiscoveryServiceGrpc;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse;
import io.envoyproxy.envoy.service.endpoint.v3.EndpointDiscoveryServiceGrpc;
import io.envoyproxy.envoy.service.listener.v3.ListenerDiscoveryServiceGrpc;
import io.envoyproxy.envoy.service.route.v3.RouteDiscoveryServiceGrpc;
import io.envoyproxy.envoy.service.secret.v3.SecretDiscoveryServiceGrpc;
import io.grpc.stub.StreamObserver;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class V3DiscoveryServer
extends DiscoveryServer<DiscoveryRequest, DiscoveryResponse> {
    public V3DiscoveryServer(ConfigWatcher configWatcher) {
        this(Collections.emptyList(), configWatcher);
    }

    public V3DiscoveryServer(DiscoveryServerCallbacks callbacks, ConfigWatcher configWatcher) {
        this(Collections.singletonList(callbacks), configWatcher);
    }

    public V3DiscoveryServer(List<DiscoveryServerCallbacks> callbacks, ConfigWatcher configWatcher) {
        this(callbacks, configWatcher, new DefaultExecutorGroup(), new DefaultProtoResourcesSerializer());
    }

    public V3DiscoveryServer(List<DiscoveryServerCallbacks> callbacks, ConfigWatcher configWatcher, ExecutorGroup executorGroup, ProtoResourcesSerializer protoResourcesSerializer) {
        super(callbacks, configWatcher, executorGroup, protoResourcesSerializer);
    }

    public AggregatedDiscoveryServiceGrpc.AggregatedDiscoveryServiceImplBase getAggregatedDiscoveryServiceImpl() {
        return new AggregatedDiscoveryServiceGrpc.AggregatedDiscoveryServiceImplBase(){

            public StreamObserver<DiscoveryRequest> streamAggregatedResources(StreamObserver<DiscoveryResponse> responseObserver) {
                return V3DiscoveryServer.this.createRequestHandler(responseObserver, true, "");
            }
        };
    }

    public ClusterDiscoveryServiceGrpc.ClusterDiscoveryServiceImplBase getClusterDiscoveryServiceImpl() {
        return new ClusterDiscoveryServiceGrpc.ClusterDiscoveryServiceImplBase(){

            public StreamObserver<DiscoveryRequest> streamClusters(StreamObserver<DiscoveryResponse> responseObserver) {
                return V3DiscoveryServer.this.createRequestHandler(responseObserver, false, "type.googleapis.com/envoy.config.cluster.v3.Cluster");
            }
        };
    }

    public EndpointDiscoveryServiceGrpc.EndpointDiscoveryServiceImplBase getEndpointDiscoveryServiceImpl() {
        return new EndpointDiscoveryServiceGrpc.EndpointDiscoveryServiceImplBase(){

            public StreamObserver<DiscoveryRequest> streamEndpoints(StreamObserver<DiscoveryResponse> responseObserver) {
                return V3DiscoveryServer.this.createRequestHandler(responseObserver, false, "type.googleapis.com/envoy.config.endpoint.v3.ClusterLoadAssignment");
            }
        };
    }

    public ListenerDiscoveryServiceGrpc.ListenerDiscoveryServiceImplBase getListenerDiscoveryServiceImpl() {
        return new ListenerDiscoveryServiceGrpc.ListenerDiscoveryServiceImplBase(){

            public StreamObserver<DiscoveryRequest> streamListeners(StreamObserver<DiscoveryResponse> responseObserver) {
                return V3DiscoveryServer.this.createRequestHandler(responseObserver, false, "type.googleapis.com/envoy.config.listener.v3.Listener");
            }
        };
    }

    public RouteDiscoveryServiceGrpc.RouteDiscoveryServiceImplBase getRouteDiscoveryServiceImpl() {
        return new RouteDiscoveryServiceGrpc.RouteDiscoveryServiceImplBase(){

            public StreamObserver<DiscoveryRequest> streamRoutes(StreamObserver<DiscoveryResponse> responseObserver) {
                return V3DiscoveryServer.this.createRequestHandler(responseObserver, false, "type.googleapis.com/envoy.config.route.v3.RouteConfiguration");
            }
        };
    }

    public SecretDiscoveryServiceGrpc.SecretDiscoveryServiceImplBase getSecretDiscoveryServiceImpl() {
        return new SecretDiscoveryServiceGrpc.SecretDiscoveryServiceImplBase(){

            public StreamObserver<DiscoveryRequest> streamSecrets(StreamObserver<DiscoveryResponse> responseObserver) {
                return V3DiscoveryServer.this.createRequestHandler(responseObserver, false, "type.googleapis.com/envoy.extensions.transport_sockets.tls.v3.Secret");
            }
        };
    }

    @Override
    protected XdsRequest wrapXdsRequest(DiscoveryRequest request) {
        return XdsRequest.create((DiscoveryRequest)request);
    }

    @Override
    protected void runStreamRequestCallbacks(long streamId, DiscoveryRequest discoveryRequest) {
        this.callbacks.forEach(cb -> cb.onV3StreamRequest(streamId, discoveryRequest));
    }

    @Override
    protected void runStreamResponseCallbacks(long streamId, XdsRequest request, DiscoveryResponse discoveryResponse) {
        Preconditions.checkArgument((request.v3Request() != null ? 1 : 0) != 0);
        this.callbacks.forEach(cb -> cb.onV3StreamResponse(streamId, request.v3Request(), discoveryResponse));
    }

    @Override
    protected DiscoveryResponse makeResponse(String version, Collection<Any> resources, String typeUrl, String nonce) {
        return DiscoveryResponse.newBuilder().setNonce(nonce).setVersionInfo(version).addAllResources(resources).setTypeUrl(typeUrl).build();
    }
}

