/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.controlplane.server;

import com.google.common.base.Preconditions;
import com.google.protobuf.Any;
import io.envoyproxy.controlplane.cache.ConfigWatcher;
import io.envoyproxy.controlplane.cache.XdsRequest;
import io.envoyproxy.controlplane.server.DefaultExecutorGroup;
import io.envoyproxy.controlplane.server.DiscoveryServer;
import io.envoyproxy.controlplane.server.DiscoveryServerCallbacks;
import io.envoyproxy.controlplane.server.ExecutorGroup;
import io.envoyproxy.controlplane.server.serializer.DefaultProtoResourcesSerializer;
import io.envoyproxy.controlplane.server.serializer.ProtoResourcesSerializer;
import io.envoyproxy.envoy.api.v2.ClusterDiscoveryServiceGrpc;
import io.envoyproxy.envoy.api.v2.DiscoveryRequest;
import io.envoyproxy.envoy.api.v2.DiscoveryResponse;
import io.envoyproxy.envoy.api.v2.EndpointDiscoveryServiceGrpc;
import io.envoyproxy.envoy.api.v2.ListenerDiscoveryServiceGrpc;
import io.envoyproxy.envoy.api.v2.RouteDiscoveryServiceGrpc;
import io.envoyproxy.envoy.service.discovery.v2.AggregatedDiscoveryServiceGrpc;
import io.envoyproxy.envoy.service.discovery.v2.SecretDiscoveryServiceGrpc;
import io.grpc.stub.StreamObserver;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class V2DiscoveryServer
extends DiscoveryServer<DiscoveryRequest, DiscoveryResponse> {
    public V2DiscoveryServer(ConfigWatcher configWatcher) {
        this(Collections.emptyList(), configWatcher);
    }

    public V2DiscoveryServer(DiscoveryServerCallbacks callbacks, ConfigWatcher configWatcher) {
        this(Collections.singletonList(callbacks), configWatcher);
    }

    public V2DiscoveryServer(List<DiscoveryServerCallbacks> callbacks, ConfigWatcher configWatcher) {
        this(callbacks, configWatcher, new DefaultExecutorGroup(), new DefaultProtoResourcesSerializer());
    }

    public V2DiscoveryServer(List<DiscoveryServerCallbacks> callbacks, ConfigWatcher configWatcher, ExecutorGroup executorGroup, ProtoResourcesSerializer protoResourcesSerializer) {
        super(callbacks, configWatcher, executorGroup, protoResourcesSerializer);
    }

    public AggregatedDiscoveryServiceGrpc.AggregatedDiscoveryServiceImplBase getAggregatedDiscoveryServiceImpl() {
        return new AggregatedDiscoveryServiceGrpc.AggregatedDiscoveryServiceImplBase(){

            public StreamObserver<DiscoveryRequest> streamAggregatedResources(StreamObserver<DiscoveryResponse> responseObserver) {
                return V2DiscoveryServer.this.createRequestHandler(responseObserver, true, "");
            }
        };
    }

    public ClusterDiscoveryServiceGrpc.ClusterDiscoveryServiceImplBase getClusterDiscoveryServiceImpl() {
        return new ClusterDiscoveryServiceGrpc.ClusterDiscoveryServiceImplBase(){

            public StreamObserver<DiscoveryRequest> streamClusters(StreamObserver<DiscoveryResponse> responseObserver) {
                return V2DiscoveryServer.this.createRequestHandler(responseObserver, false, "type.googleapis.com/envoy.api.v2.Cluster");
            }
        };
    }

    public EndpointDiscoveryServiceGrpc.EndpointDiscoveryServiceImplBase getEndpointDiscoveryServiceImpl() {
        return new EndpointDiscoveryServiceGrpc.EndpointDiscoveryServiceImplBase(){

            public StreamObserver<DiscoveryRequest> streamEndpoints(StreamObserver<DiscoveryResponse> responseObserver) {
                return V2DiscoveryServer.this.createRequestHandler(responseObserver, false, "type.googleapis.com/envoy.api.v2.ClusterLoadAssignment");
            }
        };
    }

    public ListenerDiscoveryServiceGrpc.ListenerDiscoveryServiceImplBase getListenerDiscoveryServiceImpl() {
        return new ListenerDiscoveryServiceGrpc.ListenerDiscoveryServiceImplBase(){

            public StreamObserver<DiscoveryRequest> streamListeners(StreamObserver<DiscoveryResponse> responseObserver) {
                return V2DiscoveryServer.this.createRequestHandler(responseObserver, false, "type.googleapis.com/envoy.api.v2.Listener");
            }
        };
    }

    public RouteDiscoveryServiceGrpc.RouteDiscoveryServiceImplBase getRouteDiscoveryServiceImpl() {
        return new RouteDiscoveryServiceGrpc.RouteDiscoveryServiceImplBase(){

            public StreamObserver<DiscoveryRequest> streamRoutes(StreamObserver<DiscoveryResponse> responseObserver) {
                return V2DiscoveryServer.this.createRequestHandler(responseObserver, false, "type.googleapis.com/envoy.api.v2.RouteConfiguration");
            }
        };
    }

    public SecretDiscoveryServiceGrpc.SecretDiscoveryServiceImplBase getSecretDiscoveryServiceImpl() {
        return new SecretDiscoveryServiceGrpc.SecretDiscoveryServiceImplBase(){

            public StreamObserver<DiscoveryRequest> streamSecrets(StreamObserver<DiscoveryResponse> responseObserver) {
                return V2DiscoveryServer.this.createRequestHandler(responseObserver, false, "type.googleapis.com/envoy.api.v2.auth.Secret");
            }
        };
    }

    @Override
    protected XdsRequest wrapXdsRequest(DiscoveryRequest request) {
        return XdsRequest.create((DiscoveryRequest)request);
    }

    @Override
    protected void runStreamRequestCallbacks(long streamId, DiscoveryRequest discoveryRequest) {
        this.callbacks.forEach(cb -> cb.onV2StreamRequest(streamId, discoveryRequest));
    }

    @Override
    protected void runStreamResponseCallbacks(long streamId, XdsRequest request, DiscoveryResponse discoveryResponse) {
        Preconditions.checkArgument((request.v2Request() != null ? 1 : 0) != 0);
        this.callbacks.forEach(cb -> cb.onStreamResponse(streamId, request.v2Request(), discoveryResponse));
    }

    @Override
    protected DiscoveryResponse makeResponse(String version, Collection<Any> resources, String typeUrl, String nonce) {
        return DiscoveryResponse.newBuilder().setNonce(nonce).setVersionInfo(version).addAllResources(resources).setTypeUrl(typeUrl).build();
    }
}

