/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.controlplane.server;

import com.google.common.base.Preconditions;
import io.envoyproxy.controlplane.cache.Resources;
import io.envoyproxy.controlplane.cache.Watch;
import io.envoyproxy.controlplane.server.DiscoveryRequestStreamObserver;
import io.envoyproxy.controlplane.server.DiscoveryServer;
import io.envoyproxy.controlplane.server.LatestDiscoveryResponse;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public class AdsDiscoveryRequestStreamObserver<T, U>
extends DiscoveryRequestStreamObserver<T, U> {
    private final ConcurrentMap<String, Watch> watches;
    private final ConcurrentMap<String, LatestDiscoveryResponse> latestResponse;
    private final ConcurrentMap<String, Set<String>> ackedResources;
    private final DiscoveryServer<T, U> discoveryServer;

    AdsDiscoveryRequestStreamObserver(StreamObserver<U> responseObserver, long streamId, Executor executor, DiscoveryServer discoveryServer) {
        super("", responseObserver, streamId, executor, discoveryServer);
        Preconditions.checkState((Resources.V2.TYPE_URLS.size() == Resources.V3.TYPE_URLS.size() ? 1 : 0) != 0);
        this.watches = new ConcurrentHashMap<String, Watch>(Resources.V2.TYPE_URLS.size());
        this.latestResponse = new ConcurrentHashMap<String, LatestDiscoveryResponse>(Resources.V2.TYPE_URLS.size());
        this.ackedResources = new ConcurrentHashMap<String, Set<String>>(Resources.V2.TYPE_URLS.size());
        this.discoveryServer = discoveryServer;
    }

    @Override
    public void onNext(T request) {
        if (this.discoveryServer.wrapXdsRequest(request).getTypeUrl().isEmpty()) {
            this.closeWithError(Status.UNKNOWN.withDescription(String.format("[%d] type URL is required for ADS", this.streamId)).asRuntimeException());
            return;
        }
        super.onNext(request);
    }

    @Override
    void cancel() {
        this.watches.values().forEach(Watch::cancel);
    }

    @Override
    boolean ads() {
        return true;
    }

    @Override
    LatestDiscoveryResponse latestResponse(String typeUrl) {
        return (LatestDiscoveryResponse)this.latestResponse.get(typeUrl);
    }

    @Override
    void setLatestResponse(String typeUrl, LatestDiscoveryResponse response) {
        this.latestResponse.put(typeUrl, response);
        if (typeUrl.equals("type.googleapis.com/envoy.api.v2.Cluster") || typeUrl.equals("type.googleapis.com/envoy.config.cluster.v3.Cluster")) {
            this.hasClusterChanged = true;
        } else if (typeUrl.equals("type.googleapis.com/envoy.api.v2.ClusterLoadAssignment") || typeUrl.equals("type.googleapis.com/envoy.config.endpoint.v3.ClusterLoadAssignment")) {
            this.hasClusterChanged = false;
        }
    }

    @Override
    Set<String> ackedResources(String typeUrl) {
        return this.ackedResources.getOrDefault(typeUrl, Collections.emptySet());
    }

    @Override
    void setAckedResources(String typeUrl, Set<String> resources) {
        this.ackedResources.put(typeUrl, resources);
    }

    @Override
    void computeWatch(String typeUrl, Supplier<Watch> watchCreator) {
        this.watches.compute(typeUrl, (s, watch) -> {
            if (watch != null) {
                watch.cancel();
            }
            return (Watch)watchCreator.get();
        });
    }
}

