/*
 * Decompiled with CFR 0.152.
 */
package io.emqx.exproto;

import com.erlport.erlang.term.Atom;
import com.erlport.erlang.term.Binary;
import com.erlport.erlang.term.Tuple;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;

public class Message {
    private String id;
    private int qos;
    private String from;
    private String topic;
    private byte[] payload;
    private long timestamp;

    public Message(String id, int qos, String from, String topic, byte[] payload, long timestamp) {
        this.id = id;
        this.qos = qos;
        this.from = from;
        this.topic = topic;
        this.payload = payload;
        this.timestamp = timestamp;
    }

    public Message(String id, int qos, String from, String topic, byte[] payload, BigInteger timestamp) {
        this.id = id;
        this.qos = qos;
        this.from = from;
        this.topic = topic;
        this.payload = payload;
        this.setTimestamp(timestamp);
    }

    public static Message[] parser(Object msgObj) {
        ArrayList<Message> messageArrayList = new ArrayList<Message>();
        if (msgObj instanceof ArrayList) {
            ArrayList messageDetailList_list = (ArrayList)msgObj;
            for (Object o : messageDetailList_list) {
                ArrayList messageDetailList = (ArrayList)o;
                messageArrayList.add(Message.parserOne(messageDetailList.toArray(new Tuple[6])));
            }
        }
        return messageArrayList.toArray(new Message[messageArrayList.size()]);
    }

    private static Message parserOne(Tuple[] messageTuplesArr) {
        Message message = new Message();
        block16: for (Tuple tuple : messageTuplesArr) {
            Atom key = (Atom)tuple.get(Integer.valueOf(0));
            Object value = tuple.get(Integer.valueOf(1));
            switch (key.value) {
                case "id": {
                    Binary value_b = (Binary)value;
                    message.setId(new String(value_b.raw));
                    continue block16;
                }
                case "qos": {
                    message.setQos((Integer)value);
                    continue block16;
                }
                case "from": {
                    Binary value_b = (Binary)value;
                    message.setFrom(new String(value_b.raw));
                    continue block16;
                }
                case "topic": {
                    Binary value_b = (Binary)value;
                    message.setTopic(new String(value_b.raw));
                    continue block16;
                }
                case "payload": {
                    Binary value_b = (Binary)value;
                    message.setPayload(value_b.raw);
                    continue block16;
                }
                case "timestamp": {
                    message.setTimestamp(value);
                }
            }
        }
        return message;
    }

    public static ArrayList<Tuple> toErlangDataType(Message message) {
        ArrayList<Tuple> tupleArrayList = new ArrayList<Tuple>();
        tupleArrayList.add(Tuple.two((Object)new Atom("id"), (Object)new Binary(message.getId())));
        tupleArrayList.add(Tuple.two((Object)new Atom("qos"), (Object)message.getQos()));
        tupleArrayList.add(Tuple.two((Object)new Atom("from"), (Object)new Binary(message.getFrom())));
        tupleArrayList.add(Tuple.two((Object)new Atom("topic"), (Object)new Binary(message.getTopic())));
        tupleArrayList.add(Tuple.two((Object)new Atom("payload"), (Object)new Binary(message.getPayload())));
        tupleArrayList.add(Tuple.two((Object)new Atom("timestamp"), (Object)new BigInteger("" + message.getTimestamp())));
        return tupleArrayList;
    }

    public Message() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getQos() {
        return this.qos;
    }

    public void setQos(int qos) {
        this.qos = qos;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Object timestamp) {
        if (timestamp instanceof BigInteger) {
            this.setTimestamp((BigInteger)timestamp);
        }
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setTimestamp(BigInteger timestamp) {
        this.timestamp = Long.parseLong(timestamp.toString());
    }

    public String toString() {
        return "EmqxDeliverMessage{id='" + this.id + '\'' + ", qos=" + this.qos + ", from='" + this.from + '\'' + ", topic='" + this.topic + '\'' + ", payload=" + Arrays.toString(this.payload) + ", timestamp=" + this.timestamp + '}';
    }
}

