/*
 * Decompiled with CFR 0.152.
 */
package io.emqx.exproto;

import com.erlport.Erlang;
import com.erlport.erlang.term.Binary;
import io.emqx.exproto.ClientInfo;
import io.emqx.exproto.Connection;
import io.emqx.exproto.ConnectionInfo;
import io.emqx.exproto.ExProto;
import io.emqx.exproto.Message;

public abstract class AbstractExProtoHandler
extends ExProto {
    public abstract void onConnectionEstablished(Connection var1, ConnectionInfo var2);

    public abstract void onConnectionReceived(Connection var1, byte[] var2);

    public abstract void onConnectionTerminated(Connection var1, String var2);

    public abstract void onConnectionDeliver(Connection var1, Message[] var2);

    public static void send(Connection connection, byte[] data) throws Exception {
        Erlang.call((String)"emqx_exproto", (String)"send", (Object[])new Object[]{connection.getPid(), new Binary(data)}, (long)5000L);
    }

    public static void terminate(Connection connection) throws Exception {
        Erlang.call((String)"emqx_exproto", (String)"close", (Object[])new Object[]{connection.getPid()}, (long)5000L);
    }

    public static void register(Connection connection, ClientInfo clientInfo) throws Exception {
        Erlang.call((String)"emqx_exproto", (String)"register", (Object[])new Object[]{connection.getPid(), ClientInfo.toErlangDataType(clientInfo)}, (long)5000L);
    }

    public static void publish(Connection connection, Message message) throws Exception {
        Erlang.call((String)"emqx_exproto", (String)"publish", (Object[])new Object[]{connection.getPid(), Message.toErlangDataType(message)}, (long)5000L);
    }

    public static void subscribe(Connection connection, String topic, int qos) throws Exception {
        Erlang.call((String)"emqx_exproto", (String)"subscribe", (Object[])new Object[]{connection.getPid(), new Binary(topic), qos}, (long)5000L);
    }

    public static void unsubscribe(Connection connection, String topic) throws Exception {
        Erlang.call((String)"emqx_exproto", (String)"unsubscribe", (Object[])new Object[]{connection.getPid(), new Binary(topic)}, (long)5000L);
    }
}

