package io.emergentlabs.emergent;

import android.util.Log;

public final class Logger {

    private static final String TAG = "Emergent";
    private static volatile boolean enabled = true;
    private static volatile boolean test = false;

    private Logger() {}

    public static void info(String message) {
        if (enabled) {
            Log.i(TAG, message);
        }
    }

    public static void debug(final String message) {
        if (test) {
            System.out.println(TAG + ": " + message);
        } else if (enabled) {
            Log.d(TAG, message);
        }
    }

    public static void warn(String message) {
        if (enabled) {
            Log.w(TAG, message);
        }
    }

    public static void error(String message, Throwable e) {
        if (enabled) {
            Log.w(TAG, message, e);
        }
    }

    public static void error(String message) {
        if (enabled) {
            Log.e(TAG, message);
        }
    }

    static void isTest(boolean test) {
        Logger.test = test;
    }

    static void setEnabled(boolean enabled) {
        Logger.enabled = enabled;
    }
}
