package io.emergentlabs.emergent;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import io.emergentlabs.emergent.service.EmergentService;

public final class Emergent {

    static Client client;

    /**
     * Initialize the static Emergent client
     *
     * @param context  an Android context, usually <code>this</code>
     */
    @Nullable
    public static void init(@NonNull Context context) {

        EmergentService.init(context);

        final Intent service = new Intent(context,
                EmergentService.class);
        context.startService(service);
    }

    public static void setString(final String key, final String value) {
        final Client client = EmergentService.getClient();
        if (client != null) {
            client.setCustomString(key, value);
        }
    }

     public static void setBoolean(final String key, final Boolean value) {
        final Client client = EmergentService.getClient();
        if (client != null) {
            client.setCustomBoolean(key, value);
        }
    }

     public static void setInteger(final String key, final Integer value) {
        final Client client = EmergentService.getClient();
        if (client != null) {
            client.setCustomInteger(key, value);
        }
     }
}
