package io.emergentlabs.emergent;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

import com.google.gson.JsonObject;

import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class ApiClient {

    private final ConnectivityManager connectivityManager;
    private final Preferences prefs;
    private final String apiAddr;
    private final OkHttpClient httpClient;

    private static final MediaType JSON
        = MediaType.parse("application/json; charset=utf-8");

    public ApiClient(final Context context, final String apiAddr) {
        this.apiAddr = apiAddr;
        this.connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        this.prefs = new Preferences(context);
        this.httpClient = new OkHttpClient();
    }

    public String createUri(final String uri) {
        return String.format("%s/%s",
                apiAddr, uri);
    }

    public void sendRequest(final Context context, final String uri,
            final JsonObject json, final Callback cb) {
        Logger.debug("Sending a request to " + uri);
        final RequestBody body = RequestBody.create(JSON, json.toString());
        Logger.debug("JSON body " + json.toString());
        final Request request = new Request.Builder()
            .url(uri)
            .post(body)
            .build();
        httpClient.newCall(request).enqueue(cb);
    }

    private boolean hasNetworkConnection() {
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnectedOrConnecting();
    }
}
