package io.emergentlabs.emergent.service;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.widget.Toast;

import io.emergentlabs.emergent.Client;
import io.emergentlabs.emergent.Config;
import io.emergentlabs.emergent.Logger;

public class EmergentService extends Service {

    private static Client client;

    @Nullable
    public static void init(@NonNull Context context) {
        client = new Client(context);
    }

    public static Client getClient() {
        // throw exception if called before init
        return client;
    }

    @Nullable
    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

    @Override
    public void onStart(Intent intent, int startid) {
        //Toast.makeText(this, "Service started by user.", Toast.LENGTH_LONG).show();
        if (client != null) {
            client.pollConfig(this);
        }
    }

    @Override
    public void onTaskRemoved(Intent intent) {
        super.onTaskRemoved(intent);
        if (client != null) {
            client.stop();
        }
        stopSelf();
    }
}
