package io.emergentlabs.emergent;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;

public class Preferences {

    private static final String PREF_NAME = "emergent";
    private static final String COUNTRY = "country";
    private static final String APP_ID = "appId";
    private static final String SESSION_ID = "sessionId";
    private static final String SESSION_TOKEN = "sessionToken";

    static Preferences session;

    private SharedPreferences prefs;
    private Editor editor;

    public Preferences(final Context context) {
        this.prefs = context.getSharedPreferences(PREF_NAME, Context.MODE_PRIVATE);
        this.editor = prefs.edit();
    }

    public void setAppId(final String appId) {
        editor.putString(APP_ID, appId).commit();
    }

    public String getAppId() {
        return prefs.getString(APP_ID, "");
    }

    public void setSessionId(final String sessionId) {
        editor.putString(SESSION_ID, sessionId).commit();
    }

    public String getSessionId() {
        return prefs.getString(SESSION_ID, "");
    }

    public void setCountry(final String country) {
        editor.putString(COUNTRY, country).commit();
    }

    public String getCountry() {
        return prefs.getString(COUNTRY, "");
    }

    public void setSessionToken(final String sessionToken) {
        editor.putString(SESSION_TOKEN, sessionToken).commit();
    }

    public String getSessionToken() {
        return prefs.getString(SESSION_TOKEN, "");
    }
}
