package io.emergentlabs.emergent;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

import org.apache.commons.io.IOUtils;

public class Utils {

    public static String decompress(final InputStream is) {
        GZIPInputStream gis = null;
        BufferedReader br = null;
        try (GZIPInputStream gzipIn = new GZIPInputStream(is)) {
            return IOUtils.toString(gzipIn, StandardCharsets.UTF_8);
        } catch (IOException e) {
            Logger.error("Could not decompress stream", e);
        }
        return null;
    }

    public static File saveBitmapToFile(Context context, String fileName, Bitmap bm) {

        final File imageFile = new File(context.getFilesDir(), fileName);

        try (ByteArrayOutputStream stream = new ByteArrayOutputStream()) {
            bm.compress(Bitmap.CompressFormat.PNG, 100, stream);
            byte[] byteArray = stream.toByteArray();

            File f = new File(context.getCacheDir(), fileName);
            f.createNewFile();
            //write the bytes in file
            FileOutputStream out = new FileOutputStream(f);
            out.write(byteArray);
            out.flush();
            out.close();
            return f;
        }
        catch (IOException e) {
            Logger.error("Could not save drawable", e);
        }
        return null;
    }

    public static Bitmap drawableToBitmap (Drawable drawable) {
        Bitmap bitmap = null;

        if (drawable instanceof BitmapDrawable) {
            BitmapDrawable bitmapDrawable = (BitmapDrawable) drawable;
            if(bitmapDrawable.getBitmap() != null) {
                return bitmapDrawable.getBitmap();
            }
        }

        if(drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0) {
            bitmap = Bitmap.createBitmap(1, 1, Bitmap.Config.ARGB_8888); // Single color bitmap will be created of 1x1 pixel
        } else {
            bitmap = Bitmap.createBitmap(drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight(), Bitmap.Config.ARGB_8888);
        }

        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    public static Drawable getAppIcon(final Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
            return packageManager.getApplicationIcon(appInfo);
        } catch ( PackageManager.NameNotFoundException e ) {
            Logger.error("Package name not found; unable to get app icon", e);
        }
        return null;
    }
}
