package io.emergentlabs.emergent;

import android.content.Context;
import android.os.Environment;
import android.widget.Toast;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.Process;
import java.lang.Runtime;
import java.lang.StringBuilder;


//final String command = String.format("logcat -d -v threadtime -f %s",
// logFile.getAbsolutePath());
public class LogUtils {

    private static String logcatCommand(final File logFile) {
        if (logFile != null) {
            return String.format("logcat -d -v threadtime -f %s", logFile.getAbsolutePath());
        } else {
            return "logcat -d -v threadtime *:*";
        }
    }

    public static File getLogExtFile(final Context context) throws IOException {
        final File extDir = Environment.getExternalStorageDirectory();
        if (!extDir.canWrite()) {
            Logger.warn("Could not write log file to external storage");
            return null;
        }

        final File logFile = new File(extDir, "emergent.log");
        if (!logFile.exists()) {
            logFile.createNewFile();
        }
        return logFile;
    }

    public static File getLogFile(final Context context) throws IOException {
        final File extDir = context.getDir("emergent", Context.MODE_PRIVATE);
        if (!extDir.canWrite()) {
            Logger.warn("Could not write log file to external storage");
            return null;
        }

        final File logFile = new File(extDir, "emergent.log");
        if (!logFile.exists()) {
            logFile.createNewFile();
        }
        return logFile;
    }

    public static void clearLogfile(final Context context) {
        try {
            final File logFile = getLogFile(context);
            if (logFile != null) {
                new PrintWriter(logFile).close();
                Logger.debug("Cleared contents of log file");
            }
        } catch (Exception e) {
            Logger.error("Could not clear log file", e);
        }
    }

    public static void extractLog(final Context context) {

        final Process process;
        final File logFile;
        final int pid = android.os.Process.myPid();

        try {
            logFile = getLogFile(context);
            process = Runtime.getRuntime().exec(logcatCommand(null));
        } catch (Exception e) {
            Logger.error("Could not run logcat", e);
            return;
        }

        Logger.debug("Application pid is " + pid);

        try (
            FileOutputStream out = new FileOutputStream(logFile, true);
            OutputStreamWriter outWriter = new OutputStreamWriter(out);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        ) {

            final StringBuilder result = new StringBuilder();
            String currentLine = null;

            int numLines = 0;

            while ((currentLine = reader.readLine()) != null) {

                final boolean skipLine = currentLine.contains("Emergent")
                    || !currentLine.contains(String.valueOf(pid));

                if (skipLine) {
                    continue;
                }

                outWriter.append(currentLine);
                outWriter.append("\n");

                Logger.debug("appending line " + currentLine);
                result.append(currentLine + "\n");
                numLines++;
            }
            Logger.debug("Number of new lines added " + numLines);
            outWriter.flush();
            clearLog(context);

        } catch (IOException e) {
            //Toast.makeText(context.getApplicationContext(), e.toString(), Toast.LENGTH_SHORT).show();
            Logger.error("Could not create log file", e);
        }
    }

    public static Integer logFileSize(final Context context) {
        final File logFile;
        try {
            logFile = getLogFile(context);
            return Integer.parseInt(String.valueOf(logFile.length() / 1024));
        } catch (Exception e) {
            Logger.error("Could not get log file", e);
        }
        return null;
    }

    public static void clearLog(final Context context) {
        try {
            Logger.debug("Clearing application log");
            Runtime.getRuntime().exec("logcat -c");
        } catch (IOException e) {
            //Toast.makeText(context.getApplicationContext(), e.toString(), Toast.LENGTH_SHORT).show();
        }
    }
}
