package io.emergentlabs.emergent;

import com.fasterxml.jackson.annotation.JsonProperty;

public class ConfigParams {

    @JsonProperty("apiAddr")
    private String apiAddr;

    @JsonProperty("appName")
    private String appName;

    @JsonProperty("s3Bucket")
    private String s3Bucket;

    @JsonProperty("enableLogging")
    private Boolean enableLogging;

    @JsonProperty("enableExceptionReporting")
    private Boolean enableExceptionReporting;

    private boolean enableNetworkStats = false;

    public String toString() {
        return String.format("Api addr: %s App name: %s S3 bucket: %s enable logging %b",
                apiAddr,
                appName, s3Bucket, enableLogging);
    }

    public String getApiAddr() {
        return apiAddr;
    }

    public void setApiAddr(final String apiAddr) {
        this.apiAddr = apiAddr;
    }

    public void setAppName(final String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return appName;
    }

    public Boolean getEnableNetworkStats() {
        return enableNetworkStats;
    }

    public void setEnableNetworkStats(final boolean enableNetworkStats) {
        this.enableNetworkStats = enableNetworkStats;
    }

    public Boolean getEnableExceptionReporting() {
        return enableExceptionReporting;
    }

    public void setEnableExceptionReporting(final boolean enableExceptionReporting) {
        this.enableExceptionReporting = enableExceptionReporting;
    }

    public Boolean getEnableLogging() {
        return enableLogging;
    }

    public void setEnableLagging(final boolean enableLogging) {
        this.enableLogging = enableLogging;
    }
}
