/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor.impl;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.name.Named;
import io.elastic.sailor.ExecutionContext;
import io.elastic.sailor.MessagePublisher;
import io.elastic.sailor.impl.CountingCallbackImpl;
import javax.json.JsonObject;

public class SnapshotCallback
extends CountingCallbackImpl {
    private ExecutionContext executionDetails;
    private MessagePublisher messagePublisher;
    private String routingKey;

    @Inject
    public SnapshotCallback(@Assisted ExecutionContext executionDetails, MessagePublisher messagePublisher, @Named(value="ELASTICIO_SNAPSHOT_ROUTING_KEY") String routingKey) {
        this.executionDetails = executionDetails;
        this.messagePublisher = messagePublisher;
        this.routingKey = routingKey;
    }

    @Override
    public void receiveData(Object data) {
        JsonObject snapshot = (JsonObject)data;
        byte[] payload = snapshot.toString().getBytes();
        this.messagePublisher.publish(this.routingKey, payload, this.executionDetails.buildAmqpProperties());
    }
}

