/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor.impl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.elastic.sailor.ObjectStorage;
import io.elastic.sailor.impl.CryptoServiceImpl;
import io.elastic.sailor.impl.HttpUtils;
import io.elastic.sailor.impl.MessageEncoding;
import javax.json.JsonObject;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStorageImpl
implements ObjectStorage {
    private static final Logger logger = LoggerFactory.getLogger(ObjectStorageImpl.class);
    private CryptoServiceImpl cryptoService;
    private String objectStorageUri;
    private String objectStorageToken;

    @Override
    public JsonObject getJsonObject(String id) {
        if (this.objectStorageUri == null) {
            logger.info("Object storage service URI is not set");
            return null;
        }
        if (this.objectStorageToken == null) {
            logger.info("Object storage auth token is not set");
            return null;
        }
        logger.info("About to retrieve object by id={}", (Object)id);
        String endpoint = String.format("%s/objects/%s", this.objectStorageUri, id);
        byte[] bytes = HttpUtils.get(endpoint, new HttpUtils.BearerAuthorizationHandler(this.objectStorageToken), 5);
        return this.cryptoService.decryptMessageContent(bytes, MessageEncoding.UTF8);
    }

    @Override
    public JsonObject postJsonObject(JsonObject object) {
        return this.post(object.toString());
    }

    @Override
    public JsonObject post(String object) {
        if (this.objectStorageUri == null) {
            logger.info("Object storage service URI is not set");
            return null;
        }
        if (this.objectStorageToken == null) {
            logger.info("Object storage auth token is not set");
            return null;
        }
        logger.info("About to post an object into the storage");
        String endpoint = String.format("%s/objects/", this.objectStorageUri);
        byte[] content = this.cryptoService.encrypt(object, MessageEncoding.UTF8);
        JsonObject result = HttpUtils.post(endpoint, (HttpEntity)new ByteArrayEntity(content), new HttpUtils.BearerAuthorizationHandler(this.objectStorageToken), 5);
        return result;
    }

    @Inject
    public void setCryptoService(CryptoServiceImpl cryptoService) {
        this.cryptoService = cryptoService;
    }

    @Inject(optional=true)
    public void setObjectStorageUri(@Named(value="ELASTICIO_OBJECT_STORAGE_URI") String objectStorageUri) {
        this.objectStorageUri = objectStorageUri;
        if (this.objectStorageUri != null && this.objectStorageUri.endsWith("/")) {
            this.objectStorageUri.substring(0, this.objectStorageUri.length() - 1);
        }
    }

    @Inject(optional=true)
    public void setObjectStorageToken(@Named(value="ELASTICIO_OBJECT_STORAGE_TOKEN") String objectStorageToken) {
        this.objectStorageToken = objectStorageToken;
    }
}

