/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor.impl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.rabbitmq.client.AMQP;
import io.elastic.api.JSON;
import io.elastic.api.Message;
import io.elastic.sailor.ComponentDescriptorResolver;
import io.elastic.sailor.MessageResolver;
import io.elastic.sailor.ObjectStorage;
import io.elastic.sailor.Step;
import io.elastic.sailor.Utils;
import io.elastic.sailor.impl.CryptoServiceImpl;
import io.elastic.sailor.impl.MessageEncoding;
import io.elastic.sailor.impl.MessageFormat;
import java.util.ArrayList;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageResolverImpl
implements MessageResolver {
    public static final int OBJECT_STORAGE_SIZE_THRESHOLD_DEFAULT = 0x100000;
    private static final Logger logger = LoggerFactory.getLogger(MessageResolverImpl.class);
    private ComponentDescriptorResolver componentDescriptorResolver;
    private Step step;
    private ObjectStorage objectStorage;
    private CryptoServiceImpl cryptoService;
    private int objectStorageSizeThreshold = 0x100000;
    private MessageFormat messageFormat;

    @Override
    public Message materialize(byte[] body, AMQP.BasicProperties properties) {
        if (this.messageFormat == MessageFormat.ERROR) {
            return this.createErrorMessage(body, properties);
        }
        MessageEncoding encoding = Utils.getMessageEncoding(properties);
        JsonObject payload = this.cryptoService.decryptMessageContent(body, encoding);
        String function = this.step.getFunction();
        JsonObject moduleObject = this.componentDescriptorResolver.findModuleObject(function);
        boolean autoResolveObjectReferences = moduleObject.getBoolean("autoResolveObjectReferences", true);
        if (!autoResolveObjectReferences) {
            logger.info("Function is configured not to retrieve message body from object storage.");
            return Utils.createMessage(payload);
        }
        logger.info("About to retrieve message body from storage");
        JsonObjectBuilder resolved = this.resolveMessage(payload);
        if (resolved == null) {
            logger.info("Message will be emitted as is");
            return Utils.createMessage(payload);
        }
        JsonObject passthrough = payload.getJsonObject("passthrough");
        JsonObjectBuilder passthroughBuilder = Json.createObjectBuilder();
        if (passthrough != null) {
            logger.info("About to retrieve passthrough from storage");
            for (String stepId : passthrough.keySet()) {
                JsonObjectBuilder resolvedStep = this.resolveMessage(passthrough.getJsonObject(stepId));
                if (resolvedStep == null) continue;
                passthroughBuilder.add(stepId, resolvedStep);
            }
        }
        resolved.add("passthrough", passthroughBuilder);
        return Utils.createMessage(resolved.build());
    }

    private Message createErrorMessage(byte[] body, AMQP.BasicProperties properties) {
        JsonObject errorBody = JSON.parse(body);
        logger.info("Error message:{}", (Object)new String(body));
        JsonObjectBuilder headers = Json.createObjectBuilder();
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.decryptPropertyAndAddToBuilder(errorBody, "error", builder);
        this.decryptPropertyAndAddToBuilder(errorBody, "errorInput", builder);
        properties.getHeaders().entrySet().stream().forEach(s -> headers.add((String)s.getKey(), s.getValue().toString()));
        return new Message.Builder().body(builder.build()).headers(headers.build()).build();
    }

    private void decryptPropertyAndAddToBuilder(JsonObject object, String propertyName, JsonObjectBuilder builder) {
        JsonString value = object.getJsonString(propertyName);
        if (value == null) {
            return;
        }
        JsonObject decrypted = this.cryptoService.decryptMessageContent(value.getString().getBytes(), MessageEncoding.BASE64);
        builder.add(propertyName, (JsonValue)decrypted);
    }

    @Override
    public JsonObject externalize(JsonObject message) {
        logger.info("Externalizing message body");
        MessageHolder messageHolder = new MessageHolder(message);
        ArrayList<MessageHolder> passthroughHolders = new ArrayList<MessageHolder>();
        JsonObject passthrough = message.getJsonObject("passthrough");
        if (passthrough != null) {
            for (String stepId : passthrough.keySet()) {
                logger.info("Externalizing passthrough step={}", (Object)stepId);
                JsonObject msg = passthrough.getJsonObject(stepId);
                passthroughHolders.add(new MessageHolder(stepId, msg));
            }
        }
        Integer passthroughSize = passthroughHolders.stream().map(e -> ((MessageHolder)e).bodyStr.length()).reduce(0, (subtotal, element) -> subtotal + element);
        int totalSize = messageHolder.bodyStr.getBytes().length + passthroughSize;
        logger.info("Message total size (body+passthrough): {} bytes", (Object)totalSize);
        if (totalSize <= this.objectStorageSizeThreshold) {
            logger.info("Message size is below the threshold of {} bytes. No externalization required.", (Object)this.objectStorageSizeThreshold);
            return message;
        }
        JsonObjectBuilder result = this.externalizeObject(messageHolder);
        JsonObjectBuilder passthroughBuilder = Json.createObjectBuilder();
        for (MessageHolder next : passthroughHolders) {
            logger.info("Externalizing passthrough step={}", (Object)next.stepId);
            JsonObjectBuilder externalizedStep = this.externalizeObject(next);
            passthroughBuilder.add(next.stepId, externalizedStep);
        }
        result.add("passthrough", passthroughBuilder);
        return result.build();
    }

    private JsonObjectBuilder externalizeObject(MessageHolder holder) {
        JsonObjectBuilder result = Utils.copy(holder.message);
        JsonObject storedObject = this.objectStorage.post(holder.bodyStr);
        JsonValue objectId = (JsonValue)storedObject.get((Object)"objectId");
        logger.info("Stored object with id={}", (Object)objectId);
        JsonObject headers = holder.message.getJsonObject("headers");
        JsonObjectBuilder headersBuilder = headers == null ? Json.createObjectBuilder() : Utils.copy(headers);
        headersBuilder.add("x-ipaas-object-storage-id", objectId);
        result.add("headers", (JsonValue)headersBuilder.build());
        result.add("body", (JsonValue)Json.createObjectBuilder().build());
        return result;
    }

    private JsonObjectBuilder resolveMessage(JsonObject message) {
        JsonObject headers = this.getNonNullJsonObject(message, "headers");
        JsonString objectId = headers.getJsonString("x-ipaas-object-storage-id");
        if (objectId == null) {
            logger.info("No id to retrieve the object from storage found");
            return null;
        }
        JsonObject object = this.objectStorage.getJsonObject(objectId.getString());
        JsonObject cleanedHeaders = Utils.omit(headers, "x-ipaas-object-storage-id");
        JsonObjectBuilder builder = Json.createObjectBuilder().add("body", (JsonValue)object).add("headers", (JsonValue)cleanedHeaders).add("attachments", (JsonValue)this.getNonNullJsonObject(message, "attachments"));
        JsonString messageId = message.getJsonString("id");
        if (messageId != null) {
            builder.add("id", messageId.getString());
        }
        return builder;
    }

    @Inject
    public void setCryptoService(CryptoServiceImpl cryptoService) {
        this.cryptoService = cryptoService;
    }

    @Inject
    public void setComponentDescriptorResolver(ComponentDescriptorResolver componentDescriptorResolver) {
        this.componentDescriptorResolver = componentDescriptorResolver;
    }

    @Inject
    public void setStep(@Named(value="StepJson") Step step) {
        this.step = step;
    }

    @Inject
    public void setObjectStorage(ObjectStorage objectStorage) {
        this.objectStorage = objectStorage;
    }

    @Inject
    public void setObjectStorageSizeThreshold(@Named(value="ELASTICIO_OBJECT_STORAGE_SIZE_THRESHOLD") int objectStorageSizeThreshold) {
        this.objectStorageSizeThreshold = objectStorageSizeThreshold;
    }

    @Inject
    public void setMessageFormat(@Named(value="ELASTICIO_INPUT_FORMAT") MessageFormat messageFormat) {
        this.messageFormat = messageFormat;
    }

    private JsonObject getNonNullJsonObject(JsonObject object, String property) {
        JsonObject value = object.getJsonObject(property);
        if (value == null) {
            return Json.createObjectBuilder().build();
        }
        return value;
    }

    private class MessageHolder {
        private String stepId;
        private JsonObject message;
        private String bodyStr;

        public MessageHolder(JsonObject message) {
            this("", message);
        }

        public MessageHolder(String stepId, JsonObject message) {
            this.stepId = stepId;
            this.message = message;
            this.bodyStr = message.getJsonObject("body").toString();
        }
    }
}

