/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor.impl;

import io.elastic.api.JSON;
import io.elastic.sailor.UnexpectedStatusCodeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import javax.json.JsonObject;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)HttpUtils.class.getName());

    public static String postJson(String url, JsonObject body, AuthorizationHandler authorizationHandler) throws IOException {
        return HttpUtils.postJson(url, body, authorizationHandler, 0);
    }

    public static JsonObject getJson(String url, AuthorizationHandler authorizationHandler) {
        return HttpUtils.getJson(url, authorizationHandler, 0);
    }

    public static JsonObject putJson(String url, JsonObject body, AuthorizationHandler authorizationHandler) {
        return HttpUtils.putJson(url, body, authorizationHandler, 0);
    }

    public static String postJson(String url, JsonObject body, AuthorizationHandler authorizationHandler, int retryCount) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/json");
        httpPost.setEntity((HttpEntity)HttpUtils.createStringEntity(body));
        byte[] bytes = HttpUtils.sendHttpRequest((HttpUriRequest)httpPost, authorizationHandler, retryCount, new ByteArrayHttpEntityCallback());
        if (bytes == null) {
            throw new RuntimeException("Null response received");
        }
        logger.info("Successfully posted json {} bytes length", (Object)body.toString().length());
        return new String(bytes);
    }

    public static JsonObject post(String url, HttpEntity body, AuthorizationHandler authorizationHandler, int retryCount) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity(body);
        JsonObject result = HttpUtils.sendHttpRequest((HttpUriRequest)httpPost, authorizationHandler, retryCount, new JsonObjectParseCallback());
        if (result == null) {
            throw new RuntimeException("Null response received");
        }
        logger.info("Successfully posted content");
        return result;
    }

    public static JsonObject getJson(String url, AuthorizationHandler authorizationHandler, int retryCount) {
        HttpGet httpGet = new HttpGet(url);
        httpGet.addHeader("User-Agent", "eio-sailor-java");
        JsonObject content = HttpUtils.sendHttpRequest((HttpUriRequest)httpGet, authorizationHandler, retryCount, new JsonObjectParseCallback());
        if (content == null) {
            throw new RuntimeException("Null response received");
        }
        return content;
    }

    public static byte[] get(String url, AuthorizationHandler authorizationHandler, int retryCount) {
        HttpGet httpGet = new HttpGet(url);
        httpGet.addHeader("User-Agent", "eio-sailor-java");
        byte[] content = HttpUtils.sendHttpRequest((HttpUriRequest)httpGet, authorizationHandler, retryCount, new ByteArrayHttpEntityCallback());
        if (content == null) {
            throw new RuntimeException("Null response received");
        }
        return content;
    }

    public static JsonObject putJson(String url, JsonObject body, AuthorizationHandler authorizationHandler, int retryCount) {
        HttpPut httpPut = new HttpPut(url);
        httpPut.addHeader("Content-Type", "application/json");
        httpPut.setEntity((HttpEntity)HttpUtils.createStringEntity(body));
        JsonObject content = HttpUtils.sendHttpRequest((HttpUriRequest)httpPut, authorizationHandler, retryCount, new JsonObjectParseCallback());
        if (content == null) {
            throw new RuntimeException("Null response received");
        }
        logger.info("Successfully put json {} bytes length", (Object)body.toString().length());
        return content;
    }

    public static void delete(String url, AuthorizationHandler authorizationHandler, int retryCount) {
        HttpDelete httpDelete = new HttpDelete(url);
        httpDelete.addHeader("Content-Type", "application/json");
        HttpUtils.sendHttpRequest((HttpUriRequest)httpDelete, authorizationHandler, retryCount, null);
        logger.info("Successfully sent delete");
    }

    public static StringEntity createStringEntity(JsonObject body) {
        return HttpUtils.createStringEntity(JSON.stringify(body));
    }

    public static StringEntity createStringEntity(String content) {
        try {
            return new StringEntity(content);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> T sendHttpRequest(HttpUriRequest request, AuthorizationHandler authorizationHandler, int retryCount, HttpEntityCallback<T> callback) {
        CloseableHttpClient httpClient = HttpClients.custom().setRetryHandler((exception, executionCount, context) -> {
            if (executionCount >= retryCount) {
                return false;
            }
            if (exception instanceof InterruptedIOException) {
                return true;
            }
            return exception instanceof SocketException;
        }).build();
        logger.info("Sending {} request to {}", (Object)request.getMethod(), (Object)request.getURI().getPath());
        try {
            authorizationHandler.authorize(request);
            CloseableHttpResponse response = httpClient.execute(request);
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            logger.info("Got {} response", (Object)statusCode);
            if (statusCode >= 400) {
                throw new UnexpectedStatusCodeException(statusCode);
            }
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity == null || callback == null) {
                T t = null;
                return t;
            }
            T result = callback.handle(responseEntity);
            EntityUtils.consume((HttpEntity)responseEntity);
            T t = result;
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static UsernamePasswordCredentials retrieveCredentialsFromUrl(URL url) {
        String userInfo = url.getUserInfo();
        if (userInfo == null) {
            throw new IllegalArgumentException("User info is missing in the given url: " + url);
        }
        String decodedUserInfo = HttpUtils.urlDecode(userInfo);
        String[] userAndPassword = decodedUserInfo.split(":");
        if (userAndPassword.length != 2) {
            throw new IllegalArgumentException("Either username or password is missing");
        }
        return new UsernamePasswordCredentials(userAndPassword[0], userAndPassword[1]);
    }

    private static String urlDecode(String input) {
        try {
            return URLDecoder.decode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String consumeToString(HttpEntity entity) {
        String result;
        try {
            result = EntityUtils.toString((HttpEntity)entity);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HttpUtils.consume(entity);
        return result;
    }

    public static void consume(HttpEntity entity) {
        try {
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface AuthorizationHandler {
        public void authorize(HttpUriRequest var1);
    }

    private static class ByteArrayHttpEntityCallback
    implements HttpEntityCallback<byte[]> {
        private ByteArrayHttpEntityCallback() {
        }

        @Override
        public byte[] handle(HttpEntity entity) {
            try {
                return IOUtils.toByteArray((InputStream)entity.getContent());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static interface HttpEntityCallback<T> {
        public T handle(HttpEntity var1);
    }

    private static class JsonObjectParseCallback
    implements HttpEntityCallback<JsonObject> {
        private JsonObjectParseCallback() {
        }

        @Override
        public JsonObject handle(HttpEntity entity) {
            if (entity == null) {
                throw new RuntimeException("Null response received");
            }
            return JSON.parseObject(HttpUtils.consumeToString(entity));
        }
    }

    public static class BearerAuthorizationHandler
    implements AuthorizationHandler {
        private String token;

        public BearerAuthorizationHandler(String token) {
            this.token = token;
        }

        @Override
        public void authorize(HttpUriRequest request) {
            request.addHeader("Authorization", "Bearer " + this.token);
        }
    }

    public static class BasicURLAuthorizationHandler
    extends AbstractBasicAuthorizationHandler {
        @Override
        UsernamePasswordCredentials createCredentials(HttpUriRequest request) {
            URL url = this.getRequestURL(request);
            return HttpUtils.retrieveCredentialsFromUrl(url);
        }

        private URL getRequestURL(HttpUriRequest request) {
            try {
                return request.getURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class BasicAuthorizationHandler
    extends AbstractBasicAuthorizationHandler {
        private UsernamePasswordCredentials credentials;

        public BasicAuthorizationHandler(String username, String password) {
            this.credentials = new UsernamePasswordCredentials(username, password);
        }

        @Override
        UsernamePasswordCredentials createCredentials(HttpUriRequest request) {
            return this.credentials;
        }

        public String getUsername() {
            return this.credentials.getUserName();
        }
    }

    static abstract class AbstractBasicAuthorizationHandler
    implements AuthorizationHandler {
        AbstractBasicAuthorizationHandler() {
        }

        abstract UsernamePasswordCredentials createCredentials(HttpUriRequest var1);

        @Override
        public void authorize(HttpUriRequest request) {
            try {
                Header header = new BasicScheme().authenticate((Credentials)this.createCredentials(request), (HttpRequest)request, null);
                request.addHeader(header);
            }
            catch (AuthenticationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

