/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor.impl;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.rabbitmq.client.AMQP;
import io.elastic.api.EventEmitter;
import io.elastic.api.HttpReply;
import io.elastic.sailor.ExecutionContext;
import io.elastic.sailor.MessagePublisher;
import io.elastic.sailor.Utils;
import io.elastic.sailor.impl.CryptoServiceImpl;
import io.elastic.sailor.impl.MessageEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpReplyCallback
implements EventEmitter.Callback {
    private static final Logger logger = LoggerFactory.getLogger(HttpReplyCallback.class);
    private MessagePublisher messagePublisher;
    private CryptoServiceImpl cipher;
    private ExecutionContext executionContext;

    @Inject
    public HttpReplyCallback(@Assisted ExecutionContext executionContext, MessagePublisher messagePublisher, CryptoServiceImpl cipher) {
        this.executionContext = executionContext;
        this.messagePublisher = messagePublisher;
        this.cipher = cipher;
    }

    @Override
    public void receive(Object data) {
        HttpReply reply = (HttpReply)data;
        JsonObjectBuilder headers = Json.createObjectBuilder();
        reply.getHeaders().entrySet().stream().forEach(entry -> headers.add((String)entry.getKey(), (String)entry.getValue()));
        JsonObject payload = Json.createObjectBuilder().add("statusCode", reply.getStatus()).add("body", this.getContentAsString(reply)).add("headers", (JsonValue)headers.build()).build();
        byte[] encryptedPayload = this.cipher.encryptJsonObject(payload, MessageEncoding.BASE64);
        this.sendHttpReply(encryptedPayload, this.createProperties());
    }

    private AMQP.BasicProperties createProperties() {
        AMQP.BasicProperties properties = this.executionContext.buildAmqpProperties();
        HashMap<String, Object> headers = new HashMap<String, Object>(properties.getHeaders());
        headers.put("protocolVersion", MessageEncoding.BASE64.protocolVersion);
        return Utils.buildAmqpProperties(headers);
    }

    private String getContentAsString(HttpReply reply) {
        try {
            return this.inputStreamAsString(reply.getContent());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String inputStreamAsString(InputStream input) throws IOException {
        StringWriter output = new StringWriter();
        char[] buffer = new char[4096];
        InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);
        int n = 0;
        while (-1 != (n = reader.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toString();
    }

    private void sendHttpReply(byte[] payload, AMQP.BasicProperties options) {
        Map headers = options.getHeaders();
        Object routingKey = headers.get("reply_to");
        if (routingKey == null) {
            throw new RuntimeException("Component emitted 'httpReply' event but 'reply_to' was not found in AMQP headers");
        }
        this.messagePublisher.publish(routingKey.toString(), payload, options);
    }
}

