/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor.impl;

import io.elastic.sailor.AmqpService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GracefulShutdownHandler {
    private static final Logger logger = LoggerFactory.getLogger(GracefulShutdownHandler.class);
    private AmqpService amqp;
    public AtomicInteger messagesProcessingCount = new AtomicInteger();
    private CountDownLatch exitSignal;

    public GracefulShutdownHandler(AmqpService amqp) {
        this.amqp = amqp;
        this.registerShutdownHook();
    }

    public void increment() {
        int count = this.messagesProcessingCount.incrementAndGet();
        logger.info("Incremented the number of messages concurrently processed to {}", (Object)count);
    }

    private void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                logger.info("Shutdown hook called. Will exit gracefully now");
                GracefulShutdownHandler.this.prepareGracefulShutdown();
            }
        });
        logger.info("Registered a graceful shutdown hook");
    }

    protected void prepareGracefulShutdown() {
        if (this.amqp == null) {
            return;
        }
        this.amqp.cancelConsumer();
        logger.info("Canceled all message consumers.");
        this.exitSignal = new CountDownLatch(this.messagesProcessingCount.get());
        long messagesCount = this.exitSignal.getCount();
        if (messagesCount > 0L) {
            logger.info("Now waiting for {} messages to be processed before exiting", (Object)messagesCount);
        }
        try {
            this.exitSignal.await();
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage());
        }
        logger.info("No messages are being processed anymore");
        this.amqp.disconnect();
    }

    public void decrement() {
        int count = this.messagesProcessingCount.decrementAndGet();
        logger.info("Decremented the number of messages concurrently processed to {}", (Object)count);
        if (this.exitSignal != null) {
            this.exitSignal.countDown();
            logger.info("Waiting for {} messages before exiting", (Object)this.exitSignal.getCount());
        }
    }
}

