/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor.impl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.rabbitmq.client.AMQP;
import io.elastic.sailor.ErrorPublisher;
import io.elastic.sailor.MessagePublisher;
import io.elastic.sailor.Utils;
import io.elastic.sailor.impl.CryptoServiceImpl;
import io.elastic.sailor.impl.MessageEncoding;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;

public class ErrorPublisherImpl
implements ErrorPublisher {
    public static final String ERROR_PROPERTY = "error";
    public static final String ERROR_INPUT_PROPERTY = "errorInput";
    private MessagePublisher messagePublisher;
    private CryptoServiceImpl cipher;
    private String routingKey;
    private boolean noErrorsReply;

    @Inject
    public ErrorPublisherImpl(MessagePublisher messagePublisher, CryptoServiceImpl cipher, @Named(value="ELASTICIO_ERROR_ROUTING_KEY") String routingKey, @Named(value="ELASTICIO_NO_ERROR_REPLIES") boolean noErrorsReply) {
        this.messagePublisher = messagePublisher;
        this.cipher = cipher;
        this.routingKey = routingKey;
        this.noErrorsReply = noErrorsReply;
    }

    @Override
    public void publish(Throwable e, AMQP.BasicProperties options, byte[] message) {
        String stackTrace = Utils.getStackTrace(e);
        JsonObjectBuilder builder = Json.createObjectBuilder().add("name", e.getClass().getName()).add("stack", stackTrace);
        if (e.getMessage() != null) {
            builder.add("message", e.getMessage());
        }
        JsonObject error = builder.build();
        String encryptedError = this.toString(this.cipher.encryptJsonObject(error, MessageEncoding.BASE64));
        JsonObjectBuilder payloadBuilder = Json.createObjectBuilder().add(ERROR_PROPERTY, encryptedError);
        if (message != null) {
            byte[] errorInput = this.createErrorInput(options, message);
            payloadBuilder.add(ERROR_INPUT_PROPERTY, this.toString(errorInput));
        }
        JsonObject payload = payloadBuilder.build();
        byte[] errorPayload = payload.toString().getBytes();
        this.messagePublisher.publish(this.routingKey, errorPayload, options);
        this.sendHttpReplyIfRequired(encryptedError, options);
    }

    private void sendHttpReplyIfRequired(String encryptedError, AMQP.BasicProperties properties) {
        Map headers = properties.getHeaders();
        Object replyTo = headers.get("reply_to");
        if (this.noErrorsReply) {
            return;
        }
        if (replyTo == null) {
            return;
        }
        HashMap<String, Boolean> newHeaders = new HashMap<String, Boolean>(headers);
        newHeaders.put("x-eio-error-response", true);
        AMQP.BasicProperties newProperties = Utils.copy(properties).headers(newHeaders).build();
        this.messagePublisher.publish(replyTo.toString(), encryptedError.getBytes(), newProperties);
    }

    private byte[] createErrorInput(AMQP.BasicProperties originalMessageProperties, byte[] message) {
        MessageEncoding messageEncoding = Utils.getMessageEncoding(originalMessageProperties);
        if (messageEncoding == MessageEncoding.UTF8) {
            String decrypted = this.cipher.decrypt(message, MessageEncoding.UTF8);
            return this.cipher.encrypt(decrypted, MessageEncoding.BASE64);
        }
        return message;
    }

    private String toString(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

