/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor.impl;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.name.Named;
import com.rabbitmq.client.AMQP;
import io.elastic.api.JSON;
import io.elastic.api.Message;
import io.elastic.sailor.ExecutionContext;
import io.elastic.sailor.MessagePublisher;
import io.elastic.sailor.MessageResolver;
import io.elastic.sailor.Utils;
import io.elastic.sailor.impl.CountingCallbackImpl;
import io.elastic.sailor.impl.CryptoServiceImpl;
import io.elastic.sailor.impl.MessageEncoding;
import java.util.HashMap;
import javax.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCallback
extends CountingCallbackImpl {
    private static final Logger logger = LoggerFactory.getLogger(DataCallback.class);
    private MessagePublisher messagePublisher;
    private CryptoServiceImpl cipher;
    private ExecutionContext executionContext;
    private MessageResolver messageResolver;
    private String routingKey;
    private boolean emitLightweightMessage;
    private MessageEncoding messageEncoding;

    @Inject
    public DataCallback(@Assisted ExecutionContext executionContext, MessagePublisher messagePublisher, CryptoServiceImpl cipher, MessageResolver messageResolver, @Named(value="ELASTICIO_DATA_ROUTING_KEY") String routingKey, @Named(value="ELASTICIO_EMIT_LIGHTWEIGHT_MESSAGE") boolean emitLightweightMessage, @Named(value="ELASTICIO_PROTOCOL_VERSION") MessageEncoding messageEncoding) {
        this.executionContext = executionContext;
        this.messagePublisher = messagePublisher;
        this.cipher = cipher;
        this.messageResolver = messageResolver;
        this.routingKey = routingKey;
        this.emitLightweightMessage = emitLightweightMessage;
        this.messageEncoding = messageEncoding;
    }

    @Override
    public void receiveData(Object data) {
        logger.info("Step produced data to be published");
        Message message = (Message)data;
        JsonObject messageAsJson = this.executionContext.createPublisheableMessage(message);
        if (this.emitLightweightMessage) {
            messageAsJson = this.messageResolver.externalize(messageAsJson);
        }
        byte[] encryptedPayload = this.cipher.encrypt(JSON.stringify(messageAsJson), this.messageEncoding);
        AMQP.BasicProperties headers = this.createProperties(message);
        this.messagePublisher.publish(this.routingKey, encryptedPayload, headers);
    }

    private AMQP.BasicProperties createProperties(Message message) {
        AMQP.BasicProperties properties = this.executionContext.buildAmqpProperties(message.getId());
        HashMap<String, Object> headers = new HashMap<String, Object>(properties.getHeaders());
        headers.put("protocolVersion", this.messageEncoding.protocolVersion);
        return Utils.buildAmqpProperties(headers);
    }
}

