/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor.impl;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.elastic.api.JSON;
import io.elastic.api.Message;
import io.elastic.sailor.Utils;
import io.elastic.sailor.impl.MessageEncoding;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.json.Json;
import javax.json.JsonObject;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CryptoServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(CryptoServiceImpl.class);
    private final String ALGORITHM = "AES/CBC/PKCS5Padding";
    private Key encryptionKey;
    private IvParameterSpec encryptionIV;

    @Inject
    public CryptoServiceImpl(@Named(value="ELASTICIO_MESSAGE_CRYPTO_PASSWORD") String password, @Named(value="ELASTICIO_MESSAGE_CRYPTO_IV") String initializationVector) {
        Preconditions.checkNotNull((Object)password, (Object)"ELASTICIO_MESSAGE_CRYPTO_PASSWORD is required");
        Preconditions.checkNotNull((Object)initializationVector, (Object)"ELASTICIO_MESSAGE_CRYPTO_IV is required");
        this.encryptionKey = this.generateKey(password);
        this.encryptionIV = new IvParameterSpec(initializationVector.getBytes());
    }

    public byte[] encryptMessage(Message message, MessageEncoding encoding) {
        return this.encrypt(message.toString(), encoding);
    }

    public byte[] encryptJsonObject(JsonObject message, MessageEncoding encoding) {
        return this.encrypt(message.toString(), encoding);
    }

    public JsonObject decryptMessageContent(byte[] bytes, MessageEncoding encoding) {
        if (bytes == null || bytes.length == 0) {
            logger.info("Message is null or empty. Returning empty JSON object");
            return Json.createObjectBuilder().build();
        }
        String decryptedMessage = this.decrypt(bytes, encoding);
        if (Utils.isJsonObject(decryptedMessage)) {
            logger.info("Parsing message JSON");
            return JSON.parseObject(decryptedMessage);
        }
        throw new RuntimeException("Message is not a JSON object: " + decryptedMessage);
    }

    public byte[] encrypt(String message, MessageEncoding encoding) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, this.encryptionKey, this.encryptionIV);
            byte[] bytes = message.getBytes("UTF-8");
            byte[] a = cipher.doFinal(bytes);
            if (encoding == MessageEncoding.BASE64) {
                return Base64.encodeBase64((byte[])a);
            }
            return a;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String decrypt(byte[] bytes, MessageEncoding encoding) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, this.encryptionKey, this.encryptionIV);
            if (encoding == MessageEncoding.BASE64) {
                bytes = Base64.decodeBase64((byte[])bytes);
            }
            byte[] messageBytes = cipher.doFinal(bytes);
            return new String(messageBytes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Key generateKey(String encryptionKey) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] key = md.digest(encryptionKey.getBytes("UTF-8"));
            return new SecretKeySpec(key, "AES");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

