/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.elastic.sailor.ApiClient;
import io.elastic.sailor.Step;
import io.elastic.sailor.impl.HttpUtils;
import javax.json.Json;
import javax.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ApiClientImpl
implements ApiClient {
    private static final Logger logger = LoggerFactory.getLogger((String)ApiClientImpl.class.getName());
    private final HttpUtils.BasicAuthorizationHandler authorizationHandler;
    private final String apiBaseUri;
    private final int retryCount;
    private boolean putIncomingMessageIntoPassThrough;

    @Inject
    public ApiClientImpl(@Named(value="ELASTICIO_API_URI") String apiUri, @Named(value="ELASTICIO_API_USERNAME") String apiUser, @Named(value="ELASTICIO_API_KEY") String apiKey, @Named(value="ELASTICIO_API_REQUEST_RETRY_ATTEMPTS") int retryCount, @Named(value="ELASTICIO_NO_SELF_PASSTRHOUGH") boolean putIncomingMessageIntoPassThrough) {
        this.authorizationHandler = new HttpUtils.BasicAuthorizationHandler(apiUser, apiKey);
        this.apiBaseUri = String.format("%s", apiUri);
        this.retryCount = retryCount;
        this.putIncomingMessageIntoPassThrough = putIncomingMessageIntoPassThrough;
    }

    @Override
    public Step retrieveFlowStep(String taskId, String stepId) {
        String path = String.format("/v1/tasks/%s/steps/%s", taskId, stepId);
        String uri = this.apiBaseUri + path;
        logger.info("Retrieving step data at: {}", (Object)path);
        JsonObject step = HttpUtils.getJson(uri, this.authorizationHandler, this.retryCount);
        return new Step(step, this.putIncomingMessageIntoPassThrough);
    }

    @Override
    public JsonObject updateAccount(String accountId, JsonObject body) {
        String path = String.format("/v1/accounts/%s", accountId);
        String uri = this.apiBaseUri + path;
        logger.info("Updating account for user {} at: {}", (Object)this.authorizationHandler.getUsername(), (Object)path);
        return HttpUtils.putJson(uri, body, this.authorizationHandler, this.retryCount);
    }

    @Override
    public void storeStartupState(String flowId, JsonObject body) {
        String uri = this.getStartupStateUrl(flowId);
        HttpUtils.postJson(uri, body, this.authorizationHandler, this.retryCount);
    }

    @Override
    public JsonObject retrieveStartupState(String flowId) {
        String uri = this.getStartupStateUrl(flowId);
        JsonObject state = HttpUtils.getJson(uri, this.authorizationHandler, this.retryCount);
        if (state == null) {
            return Json.createObjectBuilder().build();
        }
        return state;
    }

    @Override
    public void deleteStartupState(String flowId) {
        String uri = this.getStartupStateUrl(flowId);
        HttpUtils.delete(uri, this.authorizationHandler, this.retryCount);
    }

    private String getStartupStateUrl(String flowId) {
        return String.format("%s/sailor-support/hooks/task/%s/startup/data", this.apiBaseUri, flowId);
    }
}

