/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor;

import com.rabbitmq.client.AMQP;
import io.elastic.api.JSON;
import io.elastic.api.Message;
import io.elastic.sailor.impl.MessageEncoding;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;

public class Utils {
    public static boolean isJsonObject(String input) {
        if (input == null) {
            return false;
        }
        try {
            JSON.parseObject(input);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getEnvVar(String key) {
        String value = Utils.getOptionalEnvVar(key);
        if (value == null) {
            throw new IllegalStateException(String.format("Env var '%s' is required", key));
        }
        return value;
    }

    public static String getOptionalEnvVar(String key) {
        String value = System.getenv(key);
        if (value == null) {
            value = System.getProperty(key);
        }
        return value;
    }

    public static AMQP.BasicProperties.Builder copy(AMQP.BasicProperties properties) {
        return new AMQP.BasicProperties.Builder().appId(properties.getAppId()).contentType(properties.getContentType()).contentEncoding(properties.getContentEncoding()).clusterId(properties.getClusterId()).correlationId(properties.getCorrelationId()).headers(properties.getHeaders()).deliveryMode(properties.getDeliveryMode()).expiration(properties.getExpiration()).messageId(properties.getMessageId()).priority(properties.getPriority()).replyTo(properties.getReplyTo()).timestamp(properties.getTimestamp()).type(properties.getType()).userId(properties.getUserId());
    }

    public static AMQP.BasicProperties buildAmqpProperties(Map<String, Object> headers) {
        return Utils.createDefaultAmqpPropertiesBuilder(headers).build();
    }

    private static AMQP.BasicProperties.Builder createDefaultAmqpPropertiesBuilder(Map<String, Object> headers) {
        return new AMQP.BasicProperties.Builder().contentType("application/json").contentEncoding("utf8").headers(headers).priority(Integer.valueOf(1)).deliveryMode(Integer.valueOf(2));
    }

    public static Message createMessage(JsonObject payload) {
        JsonString id = payload.getJsonString("id");
        JsonObject attachments = payload.getJsonObject("attachments");
        JsonObject body = payload.getJsonObject("body");
        JsonObject headers = payload.getJsonObject("headers");
        JsonString method = payload.getJsonString("method");
        JsonString originalUrl = payload.getJsonString("originalUrl");
        JsonObject query = payload.getJsonObject("query");
        JsonObject passthrough = payload.getJsonObject("passthrough");
        JsonString url = payload.getJsonString("url");
        if (attachments == null) {
            attachments = Json.createObjectBuilder().build();
        }
        if (body == null) {
            body = Json.createObjectBuilder().build();
        }
        if (headers == null) {
            headers = Json.createObjectBuilder().build();
        }
        if (passthrough == null) {
            passthrough = Json.createObjectBuilder().build();
        }
        Message.Builder builder = new Message.Builder().attachments(attachments).body(body).headers(headers).passthrough(passthrough);
        if (id != null) {
            builder.id(UUID.fromString(id.getString()));
        }
        if (method != null) {
            builder.method(method.getString());
        }
        if (originalUrl != null) {
            builder.originalUrl(originalUrl.getString());
        }
        if (query != null) {
            builder.query(query);
        }
        if (url != null) {
            builder.url(url.getString());
        }
        return builder.build();
    }

    public static JsonObject pick(JsonObject obj, String ... properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties must not be null");
        }
        List<String> propertiesList = Arrays.asList(properties);
        JsonObjectBuilder result = Json.createObjectBuilder();
        obj.entrySet().stream().filter(s -> propertiesList.contains(s.getKey())).forEach(s -> result.add((String)s.getKey(), (JsonValue)s.getValue()));
        return result.build();
    }

    public static String getThreadId(AMQP.BasicProperties properties) {
        Map headers = properties.getHeaders();
        Object threadId = headers.get("threadId");
        Object traceId = headers.get("x-eio-meta-trace-id");
        if (threadId != null) {
            return threadId.toString();
        }
        if (traceId != null) {
            return traceId.toString();
        }
        return "unknown";
    }

    public static JsonObjectBuilder copy(JsonObject object) {
        JsonObjectBuilder result = Json.createObjectBuilder();
        object.entrySet().stream().forEach(s -> result.add((String)s.getKey(), (JsonValue)s.getValue()));
        return result;
    }

    public static JsonObject omit(JsonObject obj, String ... properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties must not be null");
        }
        List<String> propertiesList = Arrays.asList(properties);
        JsonObjectBuilder result = Json.createObjectBuilder();
        obj.entrySet().stream().filter(s -> !propertiesList.contains(s.getKey())).forEach(s -> result.add((String)s.getKey(), (JsonValue)s.getValue()));
        return result.build();
    }

    public static String getStackTrace(Throwable e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public static MessageEncoding getMessageEncoding(AMQP.BasicProperties properties) {
        Number protocolVersion = properties.getHeaders().getOrDefault("protocolVersion", MessageEncoding.BASE64.protocolVersion);
        return MessageEncoding.fromProtocolVersion(protocolVersion.intValue());
    }
}

