/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor;

import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonString;

public final class Step {
    private final String id;
    private final String compId;
    private final String function;
    private final JsonObject cfg;
    private final JsonObject snapshot;
    private final boolean passThroughRequired;
    private final boolean putIncomingMessageIntoPassThrough;

    public Step(JsonObject data) {
        this(data, false);
    }

    public Step(JsonObject data, boolean putIncomingMessageIntoPassThrough) {
        this.id = Step.getAsRequiredString(data, "id");
        this.compId = Step.getAsRequiredString(data, "comp_id");
        this.function = Step.getAsRequiredString(data, "function");
        this.cfg = Step.getAsNullSafeObject(data, "config");
        this.snapshot = Step.getAsNullSafeObject(data, "snapshot");
        this.passThroughRequired = data.getBoolean("is_passthrough", false);
        this.putIncomingMessageIntoPassThrough = putIncomingMessageIntoPassThrough;
    }

    public String getId() {
        return this.id;
    }

    public String getCompId() {
        return this.compId;
    }

    public String getFunction() {
        return this.function;
    }

    public JsonObject getCfg() {
        return this.cfg;
    }

    public JsonObject getSnapshot() {
        return this.snapshot;
    }

    public boolean isPassThroughRequired() {
        return this.passThroughRequired;
    }

    public boolean isPutIncomingMessageIntoPassThrough() {
        return this.putIncomingMessageIntoPassThrough;
    }

    private static String getAsRequiredString(JsonObject data, String name) {
        JsonString value = data.getJsonString(name);
        if (value == null) {
            throw new IllegalArgumentException(String.format("Step's %s is required", name));
        }
        return value.getString();
    }

    private static JsonObject getAsNullSafeObject(JsonObject data, String name) {
        JsonObject value = data.getJsonObject(name);
        if (value != null) {
            return value;
        }
        return Json.createObjectBuilder().build();
    }
}

