/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor;

import io.elastic.api.CredentialsVerifier;
import io.elastic.api.DynamicMetadataProvider;
import io.elastic.api.InvalidCredentialsException;
import io.elastic.api.SelectModelProvider;
import io.elastic.sailor.ServiceExecutionParameters;
import java.lang.reflect.Constructor;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ServiceMethods {
    verifyCredentials{

        @Override
        JsonObject execute(ServiceExecutionParameters params) {
            logger.info("About to verify credentials");
            String verifierClassName = params.getCredentialsVerifierClassName();
            if (verifierClassName == null) {
                logger.info("No implementation of {} found", (Object)CredentialsVerifier.class.getName());
                return this.createResult(true, null);
            }
            CredentialsVerifier verifier = (CredentialsVerifier)ServiceMethods.newInstance(verifierClassName);
            try {
                verifier.verify(params.getConfiguration());
                return this.createResult(true, null);
            }
            catch (InvalidCredentialsException e) {
                return this.createResult(false, e.getMessage());
            }
        }

        private JsonObject createResult(boolean verified, String errMessage) {
            JsonObjectBuilder result = Json.createObjectBuilder().add("verified", verified);
            if (errMessage != null) {
                result.add("reason", errMessage);
            }
            return result.build();
        }
    }
    ,
    getMetaModel{

        @Override
        JsonObject execute(ServiceExecutionParameters params) {
            DynamicMetadataProvider provider = (DynamicMetadataProvider)ServiceMethods.newInstance(params.getTriggerOrAction(), "dynamicMetadata");
            return provider.getMetaModel(params.getConfiguration());
        }
    }
    ,
    selectModel{

        @Override
        JsonObject execute(ServiceExecutionParameters params) {
            SelectModelProvider provider = (SelectModelProvider)ServiceMethods.newInstance(params.getModelClassName());
            return provider.getSelectModel(params.getConfiguration());
        }
    };

    private static final Logger logger;

    abstract JsonObject execute(ServiceExecutionParameters var1);

    public static ServiceMethods parse(String input) {
        if (input == null) {
            throw new IllegalArgumentException("Failed to parse a service method from null input");
        }
        for (ServiceMethods next : ServiceMethods.values()) {
            if (!next.name().equalsIgnoreCase(input)) continue;
            return next;
        }
        throw new IllegalStateException("Failed to parse a service method from input:" + input);
    }

    private static <T> T newInstance(JsonObject triggerOrAction, String name) {
        if (triggerOrAction == null) {
            throw new IllegalStateException(String.format("Env var '%s' is required", "ELASTICIO_ACTION_OR_TRIGGER"));
        }
        JsonString className = triggerOrAction.getJsonString(name);
        if (className == null) {
            throw new IllegalStateException(name + " is required");
        }
        return ServiceMethods.newInstance(className.getString());
    }

    private static <T> T newInstance(String className) {
        logger.info("Instantiating class {}", (Object)className);
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            return (T)clazz.cast(constructor.newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        logger = LoggerFactory.getLogger((String)ServiceMethods.class.getName());
    }
}

