/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Named;
import io.elastic.sailor.ComponentDescriptorResolver;
import io.elastic.sailor.ServiceEnvironmentModule;
import io.elastic.sailor.ServiceExecutionParameters;
import io.elastic.sailor.ServiceMethods;
import io.elastic.sailor.ServiceModule;
import io.elastic.sailor.impl.HttpUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Service {
    private static final Logger logger = LoggerFactory.getLogger((String)Service.class.getName());
    private ComponentDescriptorResolver resolver;
    private String postResultUrl;
    private JsonObject configuration;
    private String triggerOrAction;
    private String metaModelName;
    private int retryCount;

    protected ServiceExecutionParameters createServiceExecutionParameters() {
        JsonObject triggerOrActionObj = null;
        if (this.triggerOrAction != null) {
            triggerOrActionObj = this.resolver.findModuleObject(this.triggerOrAction);
        }
        return new ServiceExecutionParameters.Builder().configuration(this.configuration).triggerOrAction(triggerOrActionObj).modelClassName(this.metaModelName).credentialsVerifierClassName(this.resolver.findCredentialsVerifier()).build();
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            throw new IllegalArgumentException("1 argument is required, but were passed " + args.length);
        }
        Service.createServiceInstanceAndExecute(args[0]);
        logger.info("Java exiting with 0");
        System.exit(0);
    }

    static void createServiceInstanceAndExecute(String methodName) {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ServiceModule(), new ServiceEnvironmentModule()});
        logger.info("Starting execution of {}", (Object)methodName);
        ServiceMethods method = ServiceMethods.parse(methodName);
        Service.getServiceInstanceAndExecute(method, injector);
    }

    public static void getServiceInstanceAndExecute(ServiceMethods method, Injector injector) {
        Service service = (Service)injector.getInstance(Service.class);
        ServiceExecutionParameters params = service.createServiceExecutionParameters();
        try {
            service.executeMethod(method, params);
        }
        catch (Exception e) {
            service.processException(e);
            throw new RuntimeException(e);
        }
    }

    private void createResponseAndSend(String status, JsonObject data) {
        JsonObject payload = Json.createObjectBuilder().add("status", status).add("data", (JsonValue)data).build();
        Service.sendData(this.postResultUrl, payload, this.retryCount);
    }

    public void executeMethod(ServiceMethods method, ServiceExecutionParameters params) {
        JsonObject data = method.execute(params);
        this.createResponseAndSend("success", data);
    }

    private void processException(Exception e) {
        e.printStackTrace();
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        JsonObject data = Json.createObjectBuilder().add("message", writer.toString()).build();
        this.createResponseAndSend("error", data);
    }

    private static void sendData(String url, JsonObject payload, int retryCnt) {
        logger.info("Sending response");
        HttpUtils.postJson(url, payload, new HttpUtils.BasicURLAuthorizationHandler(), retryCnt);
        logger.info("Received response from server");
    }

    @Inject
    public void setResolver(ComponentDescriptorResolver resolver) {
        this.resolver = resolver;
    }

    @Inject
    public void setPostResultUrl(@Named(value="ELASTICIO_POST_RESULT_URL") String postResultUrl) {
        this.postResultUrl = postResultUrl;
    }

    @Inject
    public void setConfiguration(@Named(value="ConfigurationJson") JsonObject configuration) {
        this.configuration = configuration;
    }

    @Inject(optional=true)
    public void setTriggerOrAction(@Named(value="ELASTICIO_ACTION_OR_TRIGGER") String triggerOrAction) {
        this.triggerOrAction = triggerOrAction;
    }

    @Inject(optional=true)
    public void setMetaModelName(@Named(value="ELASTICIO_GET_MODEL_METHOD") String metaModelName) {
        this.metaModelName = metaModelName;
    }

    @Inject
    public void setRetryCount(@Named(value="ELASTICIO_API_REQUEST_RETRY_ATTEMPTS") int retryCount) {
        this.retryCount = retryCount;
    }
}

