/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Named;
import io.elastic.api.Function;
import io.elastic.api.InitParameters;
import io.elastic.api.ShutdownParameters;
import io.elastic.api.StartupParameters;
import io.elastic.sailor.AmqpAwareModule;
import io.elastic.sailor.AmqpEnvironmentModule;
import io.elastic.sailor.AmqpService;
import io.elastic.sailor.ApiClient;
import io.elastic.sailor.ContainerContext;
import io.elastic.sailor.ErrorPublisher;
import io.elastic.sailor.FunctionBuilder;
import io.elastic.sailor.SailorEnvironmentModule;
import io.elastic.sailor.SailorModule;
import io.elastic.sailor.Step;
import io.elastic.sailor.UnexpectedStatusCodeException;
import io.elastic.sailor.Utils;
import io.elastic.sailor.impl.BunyanJsonLayout;
import io.elastic.sailor.impl.GracefulShutdownHandler;
import java.io.IOException;
import java.util.HashMap;
import javax.json.Json;
import javax.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sailor {
    private static final Logger logger = LoggerFactory.getLogger(Sailor.class);
    private FunctionBuilder functionBuilder;
    private Step step;
    private ContainerContext containerContext;
    private ApiClient apiClient;
    private boolean isShutdownRequired;
    private AmqpService amqp;
    private ErrorPublisher errorPublisher;
    public static GracefulShutdownHandler gracefulShutdownHandler;

    public static void main(String[] args) throws IOException {
        logger.info("About to init Sailor");
        Sailor.createAndStartSailor(true);
    }

    static Sailor createAndStartSailor(boolean initGracefulShutdownHandler) throws IOException {
        Module[] modules = new Module[]{new SailorModule(), new SailorEnvironmentModule()};
        Injector injector = Guice.createInjector((Module[])modules);
        Sailor sailor = (Sailor)injector.getInstance(Sailor.class);
        sailor.startOrShutdown(injector, initGracefulShutdownHandler);
        return sailor;
    }

    @Inject
    public void setFunctionBuilder(FunctionBuilder functionBuilder) {
        this.functionBuilder = functionBuilder;
    }

    @Inject
    public void setStep(@Named(value="StepJson") Step step) {
        this.step = step;
    }

    @Inject
    public void setContainerContext(ContainerContext containerContext) {
        this.containerContext = containerContext;
        BunyanJsonLayout.containerContext = containerContext;
    }

    @Inject
    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Inject
    public void setShutdownRequired(@Named(value="ELASTICIO_HOOK_SHUTDOWN") boolean shutdownRequired) {
        this.isShutdownRequired = shutdownRequired;
    }

    public void startOrShutdown(Injector injector, boolean initGracefulShutdownHandler) {
        if (this.isShutdownRequired) {
            this.shutdown();
            return;
        }
        Injector childInjector = injector.createChildInjector(new Module[]{new AmqpAwareModule(), new AmqpEnvironmentModule()});
        this.start(childInjector);
    }

    public void start(Injector injector) {
        this.amqp = (AmqpService)injector.getInstance(AmqpService.class);
        logger.info("Connecting to AMQP");
        this.amqp.connectAndSubscribe();
        this.errorPublisher = (ErrorPublisher)injector.getInstance(ErrorPublisher.class);
        gracefulShutdownHandler = new GracefulShutdownHandler(this.amqp);
        try {
            logger.info("Processing flow step: {}", (Object)this.step.getId());
            logger.info("Component id to be executed: {}", (Object)this.step.getCompId());
            logger.info("Function to be executed: {}", (Object)this.step.getFunction());
            JsonObject cfg = this.step.getCfg();
            Function function = this.functionBuilder.build();
            this.startupModule(function, cfg);
            logger.info("Initializing function for execution");
            InitParameters initParameters = new InitParameters.Builder().configuration(cfg).build();
            function.init(initParameters);
            logger.info("Subscribing to queues");
            this.amqp.subscribeConsumer(function);
        }
        catch (Exception e) {
            this.reportException(e);
        }
        logger.info("Sailor started");
    }

    private void startupModule(Function function, JsonObject cfg) {
        if (this.containerContext.isStartupRequired()) {
            logger.info("Starting up component function");
            StartupParameters startupParameters = new StartupParameters.Builder().configuration(cfg).build();
            JsonObject state = function.startup(startupParameters);
            if (state == null || state.isEmpty()) {
                state = Json.createObjectBuilder().build();
            }
            String flowId = this.containerContext.getFlowId();
            try {
                this.apiClient.storeStartupState(flowId, state);
            }
            catch (UnexpectedStatusCodeException e) {
                logger.warn("Startup data already exists. Rewriting.");
                this.apiClient.deleteStartupState(flowId);
                this.apiClient.storeStartupState(flowId, state);
            }
        }
    }

    public void shutdown() {
        logger.info("Shutting down component");
        String flowId = this.containerContext.getFlowId();
        JsonObject cfg = this.step.getCfg();
        Function function = this.functionBuilder.build();
        JsonObject state = this.apiClient.retrieveStartupState(flowId);
        ShutdownParameters shutdownParameters = new ShutdownParameters.Builder().configuration(cfg).state(state).build();
        function.shutdown(shutdownParameters);
        this.apiClient.deleteStartupState(flowId);
        logger.info("Component shut down successfully");
    }

    private void reportException(Exception e) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("containerId", this.containerContext.getContainerId());
        headers.put("workspaceId", this.containerContext.getWorkspaceId());
        headers.put("execId", this.containerContext.getExecId());
        headers.put("taskId", this.containerContext.getFlowId());
        headers.put("userId", this.containerContext.getUserId());
        headers.put("stepId", this.containerContext.getStepId());
        headers.put("compId", this.containerContext.getCompId());
        headers.put("function", this.containerContext.getFunction());
        this.errorPublisher.publish(e, Utils.buildAmqpProperties(headers), null);
    }
}

