/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor;

import com.rabbitmq.client.AMQP;
import io.elastic.api.Message;
import io.elastic.sailor.ContainerContext;
import io.elastic.sailor.Step;
import io.elastic.sailor.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionContext {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionContext.class);
    private final Step step;
    private byte[] rawMessage;
    private final Message message;
    private final AMQP.BasicProperties amqpProperties;
    private final ContainerContext containerContext;

    public ExecutionContext(Step step, byte[] rawMessage, Message message, AMQP.BasicProperties amqpProperties, ContainerContext containerContext) {
        this.step = step;
        this.rawMessage = rawMessage;
        this.message = message;
        this.amqpProperties = amqpProperties;
        this.containerContext = containerContext;
    }

    public Step getStep() {
        return this.step;
    }

    public Map<String, Object> buildDefaultHeaders() {
        Object protocolVersion;
        Object parentMessageId;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map headers = this.amqpProperties.getHeaders();
        result.put("threadId", Utils.getThreadId(this.amqpProperties));
        result.put("containerId", this.containerContext.getContainerId());
        result.put("workspaceId", this.containerContext.getWorkspaceId());
        result.put("execId", headers.get("execId"));
        result.put("taskId", headers.get("taskId"));
        result.put("userId", headers.get("userId"));
        result.put("stepId", this.step.getId());
        result.put("compId", this.step.getCompId());
        result.put("function", this.step.getFunction());
        result.put("start", System.currentTimeMillis());
        Object replyTo = headers.get("reply_to");
        if (replyTo != null) {
            result.put("reply_to", replyTo);
        }
        if ((parentMessageId = headers.get("messageId")) != null) {
            result.put("parentMessageId", parentMessageId);
        }
        if ((protocolVersion = headers.get("protocolVersion")) != null) {
            result.put("protocolVersion", protocolVersion);
        }
        headers.entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase().startsWith("x-eio-meta-")).forEach(entry -> result.put(((String)entry.getKey()).toLowerCase(), entry.getValue()));
        return result;
    }

    public AMQP.BasicProperties buildAmqpProperties() {
        return this.buildAmqpProperties(UUID.randomUUID());
    }

    public AMQP.BasicProperties buildAmqpProperties(UUID messageId) {
        if (messageId == null) {
            throw new IllegalArgumentException("messageId is required");
        }
        Map<String, Object> headers = this.buildDefaultHeaders();
        headers.put("messageId", messageId.toString());
        return Utils.buildAmqpProperties(headers);
    }

    public byte[] getRawMessage() {
        return this.rawMessage;
    }

    public Message getMessage() {
        return this.message;
    }

    public Map<String, Object> getHeaders() {
        return this.amqpProperties.getHeaders();
    }

    public JsonObject createPublisheableMessage(Message message) {
        JsonObject messageAsJson = Utils.pick(message.toJsonObject(), "id", "attachments", "body", "headers", "method", "originalUrl", "query", "url");
        if (!this.step.isPassThroughRequired()) {
            return messageAsJson;
        }
        JsonObjectBuilder result = this.createJsonObjectBuilder(messageAsJson);
        JsonObjectBuilder passthroughBuilder = this.createPassthroughBuilder();
        if (this.step.isPutIncomingMessageIntoPassThrough()) {
            logger.info("Pass-through mode detected: incoming message");
            Object previousStepId = this.amqpProperties.getHeaders().get("stepId");
            if (previousStepId != null) {
                logger.info("Adding message of step '{}' into pass-through", previousStepId);
                JsonObject incomingMessageWithoutPassThrough = Utils.pick(this.message.toJsonObject(), "id", "attachments", "body", "headers");
                passthroughBuilder.add(previousStepId.toString(), (JsonValue)incomingMessageWithoutPassThrough);
            }
        } else {
            logger.info("Adding message of step '{}' into pass-through", (Object)this.step.getId());
            passthroughBuilder.add(this.step.getId(), (JsonValue)messageAsJson);
        }
        result.add("passthrough", passthroughBuilder);
        return result.build();
    }

    private JsonObjectBuilder createPassthroughBuilder() {
        if (this.message.getPassthrough() == null) {
            return Json.createObjectBuilder();
        }
        return this.createJsonObjectBuilder(this.message.getPassthrough());
    }

    private JsonObjectBuilder createJsonObjectBuilder(JsonObject obj) {
        JsonObjectBuilder result = Json.createObjectBuilder();
        obj.entrySet().stream().forEach(s -> result.add((String)s.getKey(), (JsonValue)s.getValue()));
        return result;
    }
}

