/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor;

import com.google.inject.name.Names;
import io.elastic.sailor.AbstractSailorModule;
import io.elastic.sailor.Utils;
import io.elastic.sailor.impl.MessageEncoding;
import io.elastic.sailor.impl.MessageFormat;
import java.lang.annotation.Annotation;

public class AmqpEnvironmentModule
extends AbstractSailorModule {
    protected void configure() {
        this.bindRequiredStringEnvVar("ELASTICIO_AMQP_URI");
        this.bindRequiredStringEnvVar("ELASTICIO_LISTEN_MESSAGES_ON");
        this.bindRequiredStringEnvVar("ELASTICIO_PUBLISH_MESSAGES_TO");
        this.bindRequiredStringEnvVar("ELASTICIO_DATA_ROUTING_KEY");
        this.bindRequiredStringEnvVar("ELASTICIO_ERROR_ROUTING_KEY");
        this.bindRequiredStringEnvVar("ELASTICIO_REBOUND_ROUTING_KEY");
        this.bindRequiredStringEnvVar("ELASTICIO_SNAPSHOT_ROUTING_KEY");
        this.bindRequiredStringEnvVar("ELASTICIO_MESSAGE_CRYPTO_PASSWORD");
        this.bindRequiredStringEnvVar("ELASTICIO_MESSAGE_CRYPTO_IV");
        this.bindOptionalIntegerEnvVar("ELASTICIO_OBJECT_STORAGE_SIZE_THRESHOLD", 0x100000);
        this.bindProtocolVersion();
        this.bindEnum(MessageFormat.class, "ELASTICIO_INPUT_FORMAT", MessageFormat.DEFAULT);
        this.bindOptionalBooleanValue("ELASTICIO_NO_ERROR_REPLIES", false);
    }

    private void bindProtocolVersion() {
        int protocolVersion = AmqpEnvironmentModule.getOptionalIntegerValue("ELASTICIO_PROTOCOL_VERSION", MessageEncoding.BASE64.protocolVersion);
        this.bind(MessageEncoding.class).annotatedWith((Annotation)Names.named((String)"ELASTICIO_PROTOCOL_VERSION")).toInstance((Object)MessageEncoding.fromProtocolVersion(protocolVersion));
    }

    private void bindMessageFormat() {
        MessageFormat format = MessageFormat.DEFAULT;
        String value = Utils.getOptionalEnvVar("ELASTICIO_INPUT_FORMAT");
        if (value != null) {
            format = MessageFormat.valueOf(value.toLowerCase());
        }
        this.bind(MessageFormat.class).annotatedWith((Annotation)Names.named((String)"ELASTICIO_INPUT_FORMAT")).toInstance((Object)format);
    }
}

