/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import io.elastic.sailor.Utils;
import java.lang.annotation.Annotation;

abstract class AbstractSailorModule
extends AbstractModule {
    AbstractSailorModule() {
    }

    void bindRequiredStringEnvVar(String name) {
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)name)).toInstance((Object)Utils.getEnvVar(name));
    }

    void bindOptionalStringEnvVar(String name) {
        String value = Utils.getOptionalEnvVar(name);
        if (value == null) {
            return;
        }
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)name)).toInstance((Object)value);
    }

    void bindOptionalIntegerEnvVar(String name, int defaultValue) {
        this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)name)).toInstance((Object)AbstractSailorModule.getOptionalIntegerValue(name, defaultValue));
    }

    void bindOptionalIntegerEnvVarIfExists(String name) {
        String value = Utils.getOptionalEnvVar(name);
        if (value == null) {
            return;
        }
        this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)name)).toInstance((Object)Integer.parseInt(value));
    }

    void bindOptionalLongEnvVar(String name, long defaultValue) {
        this.bind(Long.class).annotatedWith((Annotation)Names.named((String)name)).toInstance((Object)AbstractSailorModule.getOptionalLongValue(name, defaultValue));
    }

    void bindOptionalYesNoEnvVar(String name) {
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)name)).toInstance((Object)AbstractSailorModule.getOptionalYesNoValue(name));
    }

    void bindOptionalBooleanValue(String key, boolean defaultValue) {
        boolean value = AbstractSailorModule.getOptionalBooleanValue(key, defaultValue);
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)key)).toInstance((Object)value);
    }

    <T extends Enum> void bindEnum(Class<T> clazz, String key, T defaultValue) {
        T value = defaultValue;
        String strValue = Utils.getOptionalEnvVar(key);
        if (strValue != null) {
            value = Enum.valueOf(clazz, strValue.toUpperCase());
        }
        this.bind(clazz).annotatedWith((Annotation)Names.named((String)key)).toInstance(value);
    }

    public static int getOptionalIntegerValue(String key, int defaultValue) {
        String value = Utils.getOptionalEnvVar(key);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    public static long getOptionalLongValue(String key, long defaultValue) {
        String value = Utils.getOptionalEnvVar(key);
        if (value != null) {
            return Long.parseLong(value);
        }
        return defaultValue;
    }

    public static boolean getOptionalYesNoValue(String key) {
        String value = Utils.getOptionalEnvVar(key);
        return value != null;
    }

    public static boolean getOptionalBooleanValue(String key, boolean defaultValue) {
        String value = Utils.getOptionalEnvVar(key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }
}

